<?php
/**
 * Склад → Заказы
 * Файл: modules/warehouse/orders.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('warehouse', 'view');

function h($s) { return htmlspecialchars((string)$s); }
function log_action($userId, $action, $recordType, $recordId, $newValues) {
    $module = 'warehouse';
    $ip = db_escape($_SERVER['REMOTE_ADDR'] ?? '');
    $ua = db_escape($_SERVER['HTTP_USER_AGENT'] ?? '');
    $newJson = db_escape(json_encode($newValues, JSON_UNESCAPED_UNICODE));
    db_query("INSERT INTO user_logs (user_id, module, action, record_type, record_id, new_values, ip_address, user_agent)
              VALUES ($userId, '$module', '$action', '" . db_escape($recordType) . "', " . (int)$recordId . ", '$newJson', '$ip', '$ua')");
}

$tab = $_GET['tab'] ?? 'material';
if (!in_array($tab, ['material','tool','consumable'], true)) $tab = 'material';

$userId = (int)($_SESSION['user_id'] ?? 0);

// локации
$visibleLocations = ACL::getUserLocations($userId);
if (!$visibleLocations) $visibleLocations = db_fetch_all("SELECT id, name FROM locations WHERE is_active=1 ORDER BY name");

// товары
$items = db_fetch_all("SELECT id, name, unit FROM items WHERE is_active=1 AND item_type='" . db_escape($tab) . "' ORDER BY name");

$errors = [];

// отметить “принято” (и сделать приход)
if (isset($_GET['receive'])) {
    requirePermission('warehouse', 'edit');
    $orderId = (int)$_GET['receive'];

    $order = db_fetch_one("SELECT * FROM material_orders WHERE id=$orderId LIMIT 1");
    if ($order && $order['status'] === 'active') {
        db_query("UPDATE material_orders SET status='received' WHERE id=$orderId");

        // приход на склад по заказу
        $qtySql = db_escape(number_format((float)$order['quantity'], 3, '.', ''));
        $reason = db_escape('Поставка по заказу #' . $orderId . '; Поставщик: ' . (string)$order['supplier']);

        db_query("INSERT INTO inventory_movements
            (movement_type, item_type, item_id, quantity, to_location_id, reason, reference_type, reference_id, movement_date, created_by)
            VALUES
            ('receipt', '" . db_escape($tab) . "', " . (int)$order['item_id'] . ", '$qtySql', " . (int)$order['location_id'] . ", '$reason', 'material_order', $orderId, CURDATE(), $userId)
        ");

        log_action($userId, 'update', 'material_order', $orderId, ['status' => 'received']);
    }

    header('Location: orders.php?tab=' . urlencode($tab));
    exit;
}

// создать заказ
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requirePermission('warehouse', 'edit');

    $itemId = (int)($_POST['item_id'] ?? 0);
    $locationId = (int)($_POST['location_id'] ?? 0);
    $qty = trim($_POST['quantity'] ?? '');
    $supplier = trim($_POST['supplier'] ?? '');
    $orderDate = trim($_POST['order_date'] ?? date('Y-m-d'));
    $expectedDate = trim($_POST['expected_date'] ?? '');

    if ($itemId <= 0) $errors[] = 'Выбери наименование';
    if ($locationId <= 0) $errors[] = 'Выбери локацию';
    if ($qty === '' || !is_numeric(str_replace(',', '.', $qty)) || (float)str_replace(',', '.', $qty) <= 0) $errors[] = 'Количество должно быть числом больше 0';
    if ($supplier === '') $errors[] = 'Поставщик обязателен';
    if ($orderDate === '') $errors[] = 'Дата заказа обязательна';

    if (!$errors) {
        $qtyVal = (float)str_replace(',', '.', $qty);
        $qtySql = db_escape(number_format($qtyVal, 2, '.', '')); // по твоему требованию 0.01 достаточно
        $supplierSql = db_escape($supplier);
        $odSql = db_escape($orderDate);
        $edSql = ($expectedDate === '') ? 'NULL' : ("'" . db_escape($expectedDate) . "'");

        db_query("INSERT INTO material_orders
            (item_id, location_id, quantity, supplier, order_date, expected_date, status, created_by)
            VALUES
            ($itemId, $locationId, '$qtySql', '$supplierSql', '$odSql', $edSql, 'active', $userId)
        ");

        $last = db_fetch_one("SELECT LAST_INSERT_ID() AS id");
        $orderId = $last ? (int)$last['id'] : 0;
        log_action($userId, 'create', 'material_order', $orderId, [
            'item_id' => $itemId,
            'location_id' => $locationId,
            'quantity' => $qtyVal,
            'supplier' => $supplier,
            'order_date' => $orderDate,
            'expected_date' => $expectedDate,
            'status' => 'active'
        ]);

        header('Location: orders.php?tab=' . urlencode($tab));
        exit;
    }
}

// список заказов
$orders = db_fetch_all("
    SELECT mo.*, i.name AS item_name, i.unit, l.name AS location_name
    FROM material_orders mo
    JOIN items i ON i.id = mo.item_id
    JOIN locations l ON l.id = mo.location_id
    WHERE i.item_type='" . db_escape($tab) . "'
    ORDER BY mo.status, mo.order_date DESC, mo.id DESC
");

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <a href="index.php?tab=<?php echo h($tab); ?>" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">← Назад</a>
        </div>
    </div>

    <div class="card" style="margin-bottom:12px;">
        <div class="card-body" style="max-width:900px;">

            <?php if ($errors): ?>
                <div class="alert alert-danger"><?php echo implode('<br>', array_map('h', $errors)); ?></div>
            <?php endif; ?>

            <form method="post">
                <div style="display:flex; gap:12px; flex-wrap:wrap; align-items:flex-end;">
                    <div style="flex:1; min-width:260px;">
                        <label>Наименование</label>
                        <select name="item_id" class="form-control">
                            <option value="0">— выбери —</option>
                            <?php foreach ($items as $it): ?>
                                <option value="<?php echo (int)$it['id']; ?>"><?php echo h($it['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div style="min-width:220px;">
                        <label>Локация</label>
                        <select name="location_id" class="form-control">
                            <option value="0">— выбери —</option>
                            <?php foreach ($visibleLocations as $loc): ?>
                                <option value="<?php echo (int)$loc['id']; ?>"><?php echo h($loc['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div style="min-width:160px;">
                        <label>Количество</label>
                        <input type="text" name="quantity" class="form-control" placeholder="например 10">
                    </div>

                    <div style="min-width:240px;">
                        <label>Поставщик</label>
                        <input type="text" name="supplier" class="form-control" placeholder="Название">
                    </div>

                    <div style="min-width:180px;">
                        <label>Дата заказа</label>
                        <input type="date" name="order_date" class="form-control" value="<?php echo h(date('Y-m-d')); ?>">
                    </div>

                    <div style="min-width:200px;">
                        <label>Ориентировочная дата</label>
                        <input type="date" name="expected_date" class="form-control">
                    </div>

                    <div>
                        <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">Добавить</button>
                    </div>
                </div>
            </form>

        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width:70px;">ID</th>
                        <th>Наименование</th>
                        <th style="width:180px;">Локация</th>
                        <th style="width:130px;">Кол-во</th>
                        <th style="width:220px;">Поставщик</th>
                        <th style="width:140px;">Заказ</th>
                        <th style="width:160px;">Ожидаем</th>
                        <th style="width:130px;">Статус</th>
                        <th style="width:120px;">Действие</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!$orders): ?>
                        <tr><td colspan="9" style="text-align:center;color:var(--text-secondary);padding:20px;">Заказов нет</td></tr>
                    <?php else: ?>
                        <?php foreach ($orders as $o): ?>
                            <tr>
                                <td><?php echo (int)$o['id']; ?></td>
                                <td><?php echo h($o['item_name']); ?></td>
                                <td><?php echo h($o['location_name']); ?></td>
                                <td><?php echo h(rtrim(rtrim((string)$o['quantity'], '0'), '.')); ?> <?php echo h($o['unit']); ?></td>
                                <td><?php echo h($o['supplier']); ?></td>
                                <td><?php echo h($o['order_date']); ?></td>
                                <td><?php echo h($o['expected_date'] ?: '—'); ?></td>
                                <td><?php echo h($o['status']); ?></td>
                                <td>
                                    <?php if ($o['status'] === 'active'): ?>
                                        <a class="btn btn-secondary" style="padding:4px 8px;font-size:12px;"
                                           href="orders.php?tab=<?php echo h($tab); ?>&receive=<?php echo (int)$o['id']; ?>"
                                           onclick="return confirm('Отметить как получено и добавить приход на склад?');">
                                            Принято
                                        </a>
                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
