<?php
/**
 * Склад → Инвентаризация (корректировка)
 * Файл: modules/warehouse/inventory.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('warehouse', 'view');

function h($s) { return htmlspecialchars((string)$s); }
function log_action($userId, $action, $recordType, $recordId, $newValues) {
    $module = 'warehouse';
    $ip = db_escape($_SERVER['REMOTE_ADDR'] ?? '');
    $ua = db_escape($_SERVER['HTTP_USER_AGENT'] ?? '');
    $newJson = db_escape(json_encode($newValues, JSON_UNESCAPED_UNICODE));
    db_query("INSERT INTO user_logs (user_id, module, action, record_type, record_id, new_values, ip_address, user_agent)
              VALUES ($userId, '$module', '$action', '" . db_escape($recordType) . "', " . (int)$recordId . ", '$newJson', '$ip', '$ua')");
}

$tab = $_GET['tab'] ?? 'material';
if (!in_array($tab, ['material','tool','consumable','product'], true)) $tab = 'material';

$userId = (int)($_SESSION['user_id'] ?? 0);

// локации
$visibleLocations = ACL::getUserLocations($userId);
if (!$visibleLocations) $visibleLocations = db_fetch_all("SELECT id, name FROM locations WHERE is_active=1 ORDER BY name");

// товары
if ($tab === 'product') {
    $items = db_fetch_all("SELECT id, name FROM products ORDER BY name");
} else {
    $items = db_fetch_all("SELECT id, name, unit FROM items WHERE is_active=1 AND item_type='" . db_escape($tab) . "' ORDER BY name");
}

$errors = [];

// текущий остаток по item+location
function current_balance($tab, $itemId, $locationId) {
    $tabSql = db_escape($tab);

    $in = db_fetch_one("
        SELECT COALESCE(SUM(quantity),0) AS s
        FROM inventory_movements
        WHERE item_type='$tabSql' AND item_id=".(int)$itemId." AND to_location_id=".(int)$locationId."
          AND movement_type IN ('receipt','transfer','assembly')
    ");
    $out = db_fetch_one("
        SELECT COALESCE(SUM(quantity),0) AS s
        FROM inventory_movements
        WHERE item_type='$tabSql' AND item_id=".(int)$itemId." AND from_location_id=".(int)$locationId."
          AND movement_type IN ('transfer','deduction','writeoff','assembly','shipment')
    ");

    return (float)($in['s'] ?? 0) - (float)($out['s'] ?? 0);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requirePermission('warehouse', 'edit');

    $itemId = (int)($_POST['item_id'] ?? 0);
    $locationId = (int)($_POST['location_id'] ?? 0);
    $newQty = trim($_POST['new_quantity'] ?? '');
    $comment = trim($_POST['comment'] ?? '');
    $date = trim($_POST['movement_date'] ?? date('Y-m-d'));

    if ($itemId <= 0) $errors[] = 'Выбери наименование';
    if ($locationId <= 0) $errors[] = 'Выбери локацию';
    if ($newQty === '' || !is_numeric(str_replace(',', '.', $newQty)) || (float)str_replace(',', '.', $newQty) < 0) $errors[] = 'Новое количество должно быть числом >= 0';
    if ($comment === '') $errors[] = 'Комментарий обязателен';

    if (!$errors) {
        $target = (float)str_replace(',', '.', $newQty);
        $cur = current_balance($tab, $itemId, $locationId);
        $delta = $target - $cur;

        if (abs($delta) < 0.0005) {
            $errors[] = 'Корректировка не нужна (количество не изменилось)';
        } else {
            $qtySql = db_escape(number_format(abs($delta), 3, '.', ''));
            $tabSql = db_escape($tab);
            $reasonSql = db_escape('Инвентаризация: ' . $comment);

            if ($delta > 0) {
                db_query("INSERT INTO inventory_movements
                    (movement_type, item_type, item_id, quantity, to_location_id, reason, reference_type, movement_date, created_by)
                    VALUES
                    ('receipt', '$tabSql', $itemId, '$qtySql', $locationId, '$reasonSql', 'inventory', '" . db_escape($date) . "', $userId)
                ");
            } else {
                // списание (для инструмента/расходника причина обязательна — у нас она есть)
                db_query("INSERT INTO inventory_movements
                    (movement_type, item_type, item_id, quantity, from_location_id, reason, reference_type, movement_date, created_by)
                    VALUES
                    ('writeoff', '$tabSql', $itemId, '$qtySql', $locationId, '$reasonSql', 'inventory', '" . db_escape($date) . "', $userId)
                ");
            }

            $last = db_fetch_one("SELECT LAST_INSERT_ID() AS id");
            $movId = $last ? (int)$last['id'] : 0;

            log_action($userId, 'create', 'inventory_movement', $movId, [
                'movement_type' => ($delta > 0 ? 'receipt' : 'writeoff'),
                'item_type' => $tab,
                'item_id' => $itemId,
                'location_id' => $locationId,
                'old_qty' => $cur,
                'new_qty' => $target,
                'comment' => $comment,
                'movement_date' => $date
            ]);

            header('Location: index.php?tab=' . urlencode($tab));
            exit;
        }
    }
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <a href="index.php?tab=<?php echo h($tab); ?>" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">← Назад</a>
        </div>
    </div>

    <div class="card">
        <div class="card-body" style="max-width:750px;">

            <?php if ($errors): ?>
                <div class="alert alert-danger"><?php echo implode('<br>', array_map('h', $errors)); ?></div>
            <?php endif; ?>

            <form method="post">
                <div class="form-group" style="margin-bottom:12px;">
                    <label>Наименование</label>
                    <select name="item_id" class="form-control">
                        <option value="0">— выбери —</option>
                        <?php foreach ($items as $it): ?>
                            <option value="<?php echo (int)$it['id']; ?>"><?php echo h($it['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Локация (склад)</label>
                    <select name="location_id" class="form-control">
                        <option value="0">— выбери —</option>
                        <?php foreach ($visibleLocations as $loc): ?>
                            <option value="<?php echo (int)$loc['id']; ?>"><?php echo h($loc['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom:12px; max-width:240px;">
                    <label>Новое количество (после инвентаризации)</label>
                    <input type="text" name="new_quantity" class="form-control" placeholder="например 100">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Комментарий (обязательно)</label>
                    <textarea name="comment" class="form-control" rows="3" placeholder="например: пересчёт на складе"></textarea>
                </div>

                <div class="form-group" style="margin-bottom:12px; max-width:220px;">
                    <label>Дата</label>
                    <input type="date" name="movement_date" class="form-control" value="<?php echo h(date('Y-m-d')); ?>">
                </div>

                <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">Сохранить</button>
            </form>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
