<?php
/**
 * Склад → Остатки
 * Файл: modules/warehouse/index.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('warehouse', 'view');

function h($s) { return htmlspecialchars((string)$s); }
function fmt_qty_local($v) {
    $s = (string)$v;
    if (strpos($s, '.') !== false) $s = rtrim(rtrim($s, '0'), '.');
    return $s === '' ? '0' : $s;
}
function tabTitle($t) {
    if ($t === 'material') return 'Материал';
    if ($t === 'tool') return 'Инструмент';
    if ($t === 'consumable') return 'Расходники';
    if ($t === 'product') return 'Склад готовых изделий';
    return $t;
}

// вкладка
$tab = $_GET['tab'] ?? 'material';
if (!in_array($tab, ['material','tool','consumable','product'], true)) $tab = 'material';

// доступные локации (если не закреплена — показываем все активные)
$userId = (int)($_SESSION['user_id'] ?? 0);
$visibleLocations = ACL::getUserLocations($userId);
if (!$visibleLocations) {
    $visibleLocations = db_fetch_all("SELECT id, name FROM locations WHERE is_active=1 ORDER BY name");
}
$locIds = array_map('intval', array_column($visibleLocations, 'id'));
$locIdsStr = $locIds ? implode(',', $locIds) : '0';

// товары для вкладки
if ($tab === 'product') {
    // продукты берём из products, остатки считаем по inventory_movements item_type='product'
    $items = db_fetch_all("
        SELECT p.id, p.name, NULL AS category_name, 'шт' AS unit
        FROM products p
        ORDER BY p.name
    ");
} else {
    $items = db_fetch_all("
        SELECT i.id, i.name, i.unit, mc.name AS category_name
        FROM items i
        LEFT JOIN material_categories mc ON mc.id = i.category_id
        WHERE i.is_active=1 AND i.item_type='" . db_escape($tab) . "'
        ORDER BY mc.name, i.name
    ");
}

// подсчёт остатков по локациям: считаем “на лету”
$balances = []; // [item_id][location_id] = qty
if ($items && $locIds) {
    $itemIds = array_map('intval', array_column($items, 'id'));
    $itemIdsStr = implode(',', $itemIds);

    // Вход в локацию: receipt, transfer, assembly (для product обычно)
    $inRows = db_fetch_all("
        SELECT item_id, to_location_id AS location_id, SUM(quantity) AS qty
        FROM inventory_movements
        WHERE to_location_id IN ($locIdsStr)
          AND item_id IN ($itemIdsStr)
          AND item_type='" . db_escape($tab) . "'
          AND movement_type IN ('receipt','transfer','assembly')
        GROUP BY item_id, to_location_id
    ");

    foreach ($inRows as $r) {
        $iid = (int)$r['item_id'];
        $lid = (int)$r['location_id'];
        $balances[$iid][$lid] = ($balances[$iid][$lid] ?? 0) + (float)$r['qty'];
    }

    // Выход из локации: transfer, deduction, writeoff, assembly (для материалов), shipment (для product)
    $outRows = db_fetch_all("
        SELECT item_id, from_location_id AS location_id, SUM(quantity) AS qty
        FROM inventory_movements
        WHERE from_location_id IN ($locIdsStr)
          AND item_id IN ($itemIdsStr)
          AND item_type='" . db_escape($tab) . "'
          AND movement_type IN ('transfer','deduction','writeoff','assembly','shipment')
        GROUP BY item_id, from_location_id
    ");

    foreach ($outRows as $r) {
        $iid = (int)$r['item_id'];
        $lid = (int)$r['location_id'];
        $balances[$iid][$lid] = ($balances[$iid][$lid] ?? 0) - (float)$r['qty'];
    }
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель (вкладки + действия) -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display:flex; flex-wrap:wrap; gap:8px; margin-bottom:8px;">
                <a href="index.php?tab=material" class="btn <?php echo $tab==='material'?'btn-primary':'btn-secondary';?>" style="padding:6px 12px;font-size:13px;">Материал</a>
                <a href="index.php?tab=tool" class="btn <?php echo $tab==='tool'?'btn-primary':'btn-secondary';?>" style="padding:6px 12px;font-size:13px;">Инструмент</a>
                <a href="index.php?tab=consumable" class="btn <?php echo $tab==='consumable'?'btn-primary':'btn-secondary';?>" style="padding:6px 12px;font-size:13px;">Расходники</a>
                <a href="index.php?tab=product" class="btn <?php echo $tab==='product'?'btn-primary':'btn-secondary';?>" style="padding:6px 12px;font-size:13px;">Склад готовых изделий</a>
            </div>

            <div style="display:flex; flex-wrap:wrap; gap:8px;">
                <a href="receipt.php?tab=<?php echo h($tab); ?>" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Приход</a>
                <a href="deduction.php?tab=<?php echo h($tab); ?>" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Расход/Выдача</a>

                <!-- Полноценная кнопка списания -->
                <a href="writeoff.php?tab=<?php echo h($tab); ?>" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Списание</a>

                <a href="inventory.php?tab=<?php echo h($tab); ?>" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Инвентаризация</a>
                <a href="orders.php?tab=<?php echo h($tab); ?>" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Заказы</a>

                <?php if ($tab === 'tool'): ?>
                    <a href="tool_repairs.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Ремонт</a>
                <?php endif; ?>

                <?php if (in_array($tab, ['material','tool','consumable'], true)): ?>
                    <a href="export_stock_<?php echo h($tab); ?>.php"
                       class="btn btn-secondary"
                       style="padding:6px 12px;font-size:13px;">
                        Экспорт Excel
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width:60px;">ID</th>
                        <th>Наименование</th>
                        <?php if ($tab !== 'product'): ?>
                            <th style="width:200px;">Категория</th>
                        <?php endif; ?>
                        <th style="width:90px;">Ед.</th>
                        <th style="width:140px;">Итого</th>
                        <?php foreach ($visibleLocations as $loc): ?>
                            <th style="width:160px;"><?php echo h($loc['name']); ?></th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!$items): ?>
                        <tr>
                            <td colspan="<?php echo 4 + ($tab!=='product'?1:0) + count($visibleLocations); ?>" style="text-align:center;color:var(--text-secondary);padding:20px;">
                                Ничего не найдено
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($items as $it): ?>
                            <?php
                                $iid = (int)$it['id'];
                                $total = 0.0;
                                foreach ($visibleLocations as $loc) {
                                    $lid = (int)$loc['id'];
                                    $q = (float)($balances[$iid][$lid] ?? 0);
                                    $total += $q;
                                }
                            ?>
                            <tr>
                                <td><?php echo $iid; ?></td>
                                <td><?php echo h($it['name']); ?></td>
                                <?php if ($tab !== 'product'): ?>
                                    <td><?php echo h($it['category_name'] ?: '—'); ?></td>
                                <?php endif; ?>
                                <td><?php echo h($it['unit'] ?? 'шт'); ?></td>
                                <td><?php echo h(fmt_qty_local($total)); ?></td>
                                <?php foreach ($visibleLocations as $loc): ?>
                                    <?php
                                        $lid = (int)$loc['id'];
                                        $q = (float)($balances[$iid][$lid] ?? 0);
                                    ?>
                                    <td><?php echo h(fmt_qty_local($q)); ?></td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

			<!-- <div style="margin-top:10px;color:var(--text-secondary);font-size:13px;">
                Остатки считаются “на лету” по движениям склада. Количества отображаются без “.000”.
            </div>  -->

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
