<?php
/**
 * Склад → Расход / Выдача
 * Файл: modules/warehouse/deduction.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('warehouse', 'view');

function h($s) { return htmlspecialchars((string)$s); }
function log_action($userId, $action, $recordType, $recordId, $newValues) {
    $module = 'warehouse';
    $ip = db_escape($_SERVER['REMOTE_ADDR'] ?? '');
    $ua = db_escape($_SERVER['HTTP_USER_AGENT'] ?? '');
    $newJson = db_escape(json_encode($newValues, JSON_UNESCAPED_UNICODE));
    db_query("INSERT INTO user_logs (user_id, module, action, record_type, record_id, new_values, ip_address, user_agent)
              VALUES ($userId, '$module', '$action', '" . db_escape($recordType) . "', " . (int)$recordId . ", '$newJson', '$ip', '$ua')");
}

$tab = $_GET['tab'] ?? 'material';
if (!in_array($tab, ['material','tool','consumable','product'], true)) $tab = 'material';
$userId = (int)($_SESSION['user_id'] ?? 0);

// локации
$visibleLocations = ACL::getUserLocations($userId);
if (!$visibleLocations) $visibleLocations = db_fetch_all("SELECT id, name FROM locations WHERE is_active=1 ORDER BY name");

// цеха (если закреплён цех — показываем только его; если нет — все)
$visibleWorkshops = ACL::getUserWorkshops($userId);
if (!$visibleWorkshops) {
    $visibleWorkshops = db_fetch_all("
        SELECT w.id, w.name, l.name AS location_name
        FROM workshops w JOIN locations l ON l.id=w.location_id
        WHERE w.is_active=1 AND l.is_active=1
        ORDER BY l.name, w.name
    ");
}

// сотрудники (employees) — пока простая таблица
$employees = db_fetch_all("SELECT id, full_name FROM employees WHERE is_active=1 ORDER BY full_name");

// товары
if ($tab === 'product') {
    $items = db_fetch_all("SELECT id, name FROM products ORDER BY name");
} else {
    $items = db_fetch_all("SELECT id, name, unit FROM items WHERE is_active=1 AND item_type='" . db_escape($tab) . "' ORDER BY name");
}

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requirePermission('warehouse', 'edit');

    $itemId = (int)($_POST['item_id'] ?? 0);
    $fromLocationId = (int)($_POST['from_location_id'] ?? 0);
    $qty = trim($_POST['quantity'] ?? '');
    $date = trim($_POST['movement_date'] ?? date('Y-m-d'));

    $recipientType = $_POST['recipient_type'] ?? 'workshop'; // workshop|employee
    $toWorkshopId = (int)($_POST['to_workshop_id'] ?? 0);
    $toEmployeeId = (int)($_POST['to_employee_id'] ?? 0);

    if ($itemId <= 0) $errors[] = 'Выбери наименование';
    if ($fromLocationId <= 0) $errors[] = 'Выбери локацию (склад)';
    if ($qty === '' || !is_numeric(str_replace(',', '.', $qty)) || (float)str_replace(',', '.', $qty) <= 0) $errors[] = 'Количество должно быть числом больше 0';

    if ($recipientType === 'workshop') {
        if ($toWorkshopId <= 0) $errors[] = 'Выбери цех';
    } elseif ($recipientType === 'employee') {
        if ($toEmployeeId <= 0) $errors[] = 'Выбери сотрудника';
    } else {
        $errors[] = 'Неверный получатель';
    }

    $comment = trim($_POST['comment'] ?? '');

    if (!$errors) {
        $qtyVal = (float)str_replace(',', '.', $qty);
        $qtySql = db_escape(number_format($qtyVal, 3, '.', ''));
        $tabSql = db_escape($tab);

        $toWorkshopSql = "NULL";
        $toEmployeeSql = "NULL";
        if ($recipientType === 'workshop') $toWorkshopSql = (string)$toWorkshopId;
        if ($recipientType === 'employee') $toEmployeeSql = (string)$toEmployeeId;

        $reasonSql = db_escape($comment);

        db_query("INSERT INTO inventory_movements
            (movement_type, item_type, item_id, quantity, from_location_id, to_workshop_id, to_employee_id, reason, reference_type, movement_date, created_by)
            VALUES
            ('deduction', '$tabSql', $itemId, '$qtySql', $fromLocationId, $toWorkshopSql, $toEmployeeSql, '$reasonSql', 'deduction', '" . db_escape($date) . "', $userId)
        ");

        $last = db_fetch_one("SELECT LAST_INSERT_ID() AS id");
        $movId = $last ? (int)$last['id'] : 0;

        log_action($userId, 'create', 'inventory_movement', $movId, [
            'movement_type' => 'deduction',
            'item_type' => $tab,
            'item_id' => $itemId,
            'quantity' => $qtyVal,
            'from_location_id' => $fromLocationId,
            'to_workshop_id' => ($recipientType==='workshop') ? $toWorkshopId : null,
            'to_employee_id' => ($recipientType==='employee') ? $toEmployeeId : null,
            'movement_date' => $date,
            'comment' => $comment
        ]);

        header('Location: index.php?tab=' . urlencode($tab));
        exit;
    }
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <a href="index.php?tab=<?php echo h($tab); ?>" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">
                ← Назад
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body" style="max-width:800px;">

            <?php if ($errors): ?>
                <div class="alert alert-danger"><?php echo implode('<br>', array_map('h', $errors)); ?></div>
            <?php endif; ?>

            <form method="post">

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Наименование</label>
                    <select name="item_id" class="form-control">
                        <option value="0">— выбери —</option>
                        <?php foreach ($items as $it): ?>
                            <option value="<?php echo (int)$it['id']; ?>"><?php echo h($it['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Со склада (локация)</label>
                    <select name="from_location_id" class="form-control">
                        <option value="0">— выбери —</option>
                        <?php foreach ($visibleLocations as $loc): ?>
                            <option value="<?php echo (int)$loc['id']; ?>"><?php echo h($loc['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom:12px; max-width:220px;">
                    <label>Количество</label>
                    <input type="text" name="quantity" class="form-control" placeholder="например 5">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Кому выдано</label>
                    <div style="display:flex; gap:12px; flex-wrap:wrap; margin-top:6px;">
                        <label><input type="radio" name="recipient_type" value="workshop" checked> Цех</label>
                        <label><input type="radio" name="recipient_type" value="employee"> Сотрудник</label>
                    </div>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Цех</label>
                    <select name="to_workshop_id" class="form-control">
                        <option value="0">— выбери —</option>
                        <?php foreach ($visibleWorkshops as $w): ?>
                            <option value="<?php echo (int)$w['id']; ?>"><?php echo h(($w['location_name'] ?? '') . ($w['location_name'] ? ' — ' : '') . $w['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Сотрудник</label>
                    <select name="to_employee_id" class="form-control">
                        <option value="0">— выбери —</option>
                        <?php foreach ($employees as $e): ?>
                            <option value="<?php echo (int)$e['id']; ?>"><?php echo h($e['full_name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div style="margin-top:6px;color:var(--text-secondary);font-size:13px;">
                        Пока модуль “Персонал” не сделан, сотрудники берутся из таблицы employees.
                    </div>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Комментарий (не обязательно)</label>
                    <textarea name="comment" class="form-control" rows="3" placeholder="например: для смены №2"></textarea>
                </div>

                <div class="form-group" style="margin-bottom:12px; max-width:220px;">
                    <label>Дата</label>
                    <input type="date" name="movement_date" class="form-control" value="<?php echo h(date('Y-m-d')); ?>">
                </div>

                <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">Сохранить</button>
            </form>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
