<?php
/**
 * Настройки → Цеха
 * Файл: modules/settings/workshops.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

// Реальное удаление цеха
if (isset($_GET['delete'])) {
    requirePermission('settings', 'edit');

    $deleteId = (int)$_GET['delete'];
    if ($deleteId > 0) {

        // 1) отвязка пользователей от цеха
        db_query("DELETE FROM user_workshops WHERE workshop_id = $deleteId");

        // 2) удаляем материалы операций этого цеха
        // (через список операций, чтобы не было FK/зависимостей)
        $ops = db_fetch_all("SELECT id FROM operations WHERE workshop_id = $deleteId");
        if ($ops) {
            $opIds = [];
            foreach ($ops as $op) {
                $opIds[] = (int)$op['id'];
            }
            if ($opIds) {
                $opIdsStr = implode(',', $opIds);
                db_query("DELETE FROM operation_materials WHERE operation_id IN ($opIdsStr)");
            }
        }

        // 3) удаляем операции цеха
        db_query("DELETE FROM operations WHERE workshop_id = $deleteId");

        // 4) удаляем сам цех
        db_query("DELETE FROM workshops WHERE id = $deleteId");
    }

    header('Location: workshops.php');
    exit;
}

// Список цехов
$workshops = db_fetch_all("
    SELECT w.id, w.name, w.location_id, l.name AS location_name
    FROM workshops w
    JOIN locations l ON l.id = w.location_id
    ORDER BY l.name, w.name
");

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display:flex; flex-wrap:wrap; gap:8px;">
                <a href="users.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Пользователи</a>
                <a href="roles.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Роли</a>
                <a href="locations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Локации</a>
                <a href="workshops.php" class="btn btn-primary" style="padding:6px 12px;font-size:13px;">Цеха</a>
                <a href="operations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Операции</a>
                <a href="material_categories.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Категории материалов</a>
                <a href="tg_bot.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">TG-бот</a>
            </div>
        </div>
    </div>

    <!-- Кнопка -->
    <div class="card" style="margin-bottom:12px;">
        <div class="card-body" style="padding:8px 12px;">
            <a href="workshop_edit.php" class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                Добавить цех
            </a>
        </div>
    </div>

    <!-- Таблица -->
    <div class="card">
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width:60px;">ID</th>
                        <th>Название цеха</th>
                        <th>Локация</th>
                        <th style="width:220px;">Действия</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!$workshops): ?>
                        <tr>
                            <td colspan="4" style="text-align:center;color:var(--text-secondary);padding:20px;">
                                Цехов пока нет
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($workshops as $w): ?>
                            <tr>
                                <td><?php echo (int)$w['id']; ?></td>
                                <td><?php echo htmlspecialchars($w['name']); ?></td>
                                <td><?php echo htmlspecialchars($w['location_name']); ?></td>
                                <td>
                                    <a href="workshop_edit.php?id=<?php echo (int)$w['id']; ?>"
                                       class="btn btn-secondary"
                                       style="padding:4px 8px;font-size:12px;">
                                        Редактировать
                                    </a>

                                    <a href="workshops.php?delete=<?php echo (int)$w['id']; ?>"
                                       class="btn btn-danger"
                                       style="padding:4px 8px;font-size:12px;"
                                       onclick="return confirm('Удалить цех? Будут удалены операции и привязки пользователей к этому цеху.');">
                                        Удалить
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
