<?php
/**
 * Настройки → Цеха → Создание / редактирование
 * Файл: modules/settings/workshop_edit.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

$workshopId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$errors = [];
$workshop = [
    'name' => '',
    'location_id' => 0,
];

$locations = db_fetch_all("SELECT id, name FROM locations WHERE is_active = 1 ORDER BY name");

// загрузка
if ($workshopId > 0) {
    $row = db_fetch_one("SELECT * FROM workshops WHERE id = $workshopId");
    if (!$row) {
        die('Цех не найден');
    }
    $workshop = $row;
}

// сохранение
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requirePermission('settings', 'edit');

    $name = trim($_POST['name'] ?? '');
    $locationId = (int)($_POST['location_id'] ?? 0);

    if ($name === '') $errors[] = 'Название обязательно';
    if ($locationId <= 0) $errors[] = 'Локация обязательна';

    // проверка уникальности: в пределах локации
    if (!$errors) {
        $nameSql = db_escape($name);
        $check = db_fetch_one("
            SELECT id
            FROM workshops
            WHERE name = '$nameSql'
              AND location_id = $locationId
              AND id <> $workshopId
            LIMIT 1
        ");
        if ($check) {
            $errors[] = 'В этой локации уже есть цех с таким названием';
        }
    }

    if (!$errors) {
        $nameSql = db_escape($name);

        if ($workshopId > 0) {
            db_query("
                UPDATE workshops
                SET name = '$nameSql',
                    location_id = $locationId
                WHERE id = $workshopId
            ");
        } else {
            db_query("
                INSERT INTO workshops (name, location_id)
                VALUES ('$nameSql', $locationId)
            ");
        }

        header('Location: workshops.php');
        exit;
    }

    $workshop['name'] = $name;
    $workshop['location_id'] = $locationId;
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <a href="workshops.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">
                ← Назад к цехам
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <?php if ($errors): ?>
                <div class="alert alert-danger">
                    <?php echo implode('<br>', $errors); ?>
                </div>
            <?php endif; ?>

            <form method="post">

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Название цеха</label>
                    <input type="text" name="name" class="form-control"
                           value="<?php echo htmlspecialchars($workshop['name'] ?? ''); ?>">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Локация</label>
                    <select name="location_id" class="form-control">
                        <option value="0">— выбери локацию —</option>
                        <?php foreach ($locations as $l): ?>
                            <option value="<?php echo (int)$l['id']; ?>"
                                <?php echo ((int)($workshop['location_id'] ?? 0) === (int)$l['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($l['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                    Сохранить
                </button>

            </form>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
