<?php
/**
 * Настройки → Пользователи
 * Файл: modules/settings/users.php
 */

require_once '../../config.php';

/**
 * Если у тебя белая страница — включаем показ ошибок на этой странице.
 * Это безопасно: действует только здесь.
 */
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

// Деактивация пользователя (удаление)
if (isset($_GET['delete'])) {
    requirePermission('settings', 'edit');

    $deleteId = (int)$_GET['delete'];
    if ($deleteId > 0 && $deleteId !== (int)$_SESSION['user_id']) {
        db_query("UPDATE users SET is_active = 0 WHERE id = $deleteId");
        db_query("DELETE FROM user_locations WHERE user_id = $deleteId");
        db_query("DELETE FROM user_workshops WHERE user_id = $deleteId");
    }

    header('Location: users.php');
    exit;
}

$sql = "
SELECT
    u.id,
    u.full_name,
    u.login,
    u.telegram_id,
    u.is_active,
    r.name AS role_name,
    GROUP_CONCAT(DISTINCT l.name ORDER BY l.name SEPARATOR ', ') AS location_names,
    GROUP_CONCAT(DISTINCT w.name ORDER BY w.name SEPARATOR ', ') AS workshop_names
FROM users u
JOIN roles r ON r.id = u.role_id
LEFT JOIN user_locations ul ON ul.user_id = u.id
LEFT JOIN locations l ON l.id = ul.location_id
LEFT JOIN user_workshops uw ON uw.user_id = u.id
LEFT JOIN workshops w ON w.id = uw.workshop_id
GROUP BY u.id, u.full_name, u.login, u.telegram_id, u.is_active, r.name
ORDER BY u.full_name
";

$users = db_fetch_all($sql);

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display:flex; flex-wrap:wrap; gap:8px;">
                <a href="users.php" class="btn btn-primary" style="padding:6px 12px;font-size:13px;">Пользователи</a>
                <a href="roles.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Роли</a>
                <a href="locations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Локации</a>
                <a href="workshops.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Цеха</a>
                <a href="operations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Операции</a>
                <a href="material_categories.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Категории материалов</a>
                <a href="tg_bot.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">TG-бот</a>
            </div>
        </div>
    </div>

    <!-- Кнопка добавления -->
    <div class="card" style="margin-bottom:12px;">
        <div class="card-body" style="padding:8px 12px;">
            <a href="user_edit.php" class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                Добавить пользователя
            </a>
        </div>
    </div>

    <!-- Таблица -->
    <div class="card">
        <div class="card-body">

            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width:60px;">ID</th>
                        <th>ФИО</th>
                        <th>Логин</th>
                        <th>Роль</th>
                        <th>Локация</th>
                        <th>Цеха</th>
                        <th style="width:100px;">Статус</th>
                        <th style="width:220px;">Действия</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!$users): ?>
                        <tr>
                            <td colspan="8" style="text-align:center;color:var(--text-secondary);padding:20px;">
                                Пользователей пока нет
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($users as $u): ?>
                            <tr>
                                <td><?php echo (int)$u['id']; ?></td>
                                <td><?php echo htmlspecialchars($u['full_name']); ?></td>
                                <td><?php echo htmlspecialchars($u['login']); ?></td>
                                <td><?php echo htmlspecialchars($u['role_name']); ?></td>
                                <td><?php echo htmlspecialchars($u['location_names'] ?: 'Все'); ?></td>
                                <td><?php echo htmlspecialchars($u['workshop_names'] ?: 'Все'); ?></td>
                                <td><?php echo ((int)$u['is_active'] === 1) ? 'Активен' : 'Отключен'; ?></td>
                                <td>
                                    <a href="user_edit.php?id=<?php echo (int)$u['id']; ?>"
                                       class="btn btn-secondary"
                                       style="padding:4px 8px;font-size:12px;">
                                        Редактировать
                                    </a>

                                    <?php if ((int)$u['id'] !== (int)$_SESSION['user_id']): ?>
                                        <a href="users.php?delete=<?php echo (int)$u['id']; ?>"
                                           class="btn btn-danger"
                                           style="padding:4px 8px;font-size:12px;"
                                           onclick="return confirm('Отключить пользователя?');">
                                            Удалить
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
