<?php
/**
 * Настройки → Пользователи → Создание / редактирование
 * Файл: modules/settings/user_edit.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

$userId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$errors = [];
$user = [
    'full_name' => '',
    'login' => '',
    'telegram_id' => '',
    'role_id' => 0,
    'is_active' => 1,
];

$currentLocationId = 0;
$currentWorkshopIds = [];

// справочники
$roles = db_fetch_all("SELECT id, name FROM roles ORDER BY name");
$locations = db_fetch_all("SELECT id, name FROM locations WHERE is_active = 1 ORDER BY name");
$workshops = db_fetch_all("
    SELECT w.id, w.name, w.location_id, l.name AS location_name
    FROM workshops w
    JOIN locations l ON l.id = w.location_id
    WHERE w.is_active = 1
    ORDER BY l.name, w.name
");

// загрузка пользователя
if ($userId > 0) {
    $row = db_fetch_one("SELECT * FROM users WHERE id = $userId");
    if (!$row) {
        die('Пользователь не найден');
    }
    $user = $row;

    $loc = db_fetch_one("SELECT location_id FROM user_locations WHERE user_id = $userId LIMIT 1");
    $currentLocationId = $loc ? (int)$loc['location_id'] : 0;

    $ws = db_fetch_all("SELECT workshop_id FROM user_workshops WHERE user_id = $userId");
    foreach ($ws as $w) {
        $currentWorkshopIds[] = (int)$w['workshop_id'];
    }
}

// сохранение
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requirePermission('settings', 'edit');

    $fullName = trim($_POST['full_name'] ?? '');
    $login = trim($_POST['login'] ?? '');
    $password = (string)($_POST['password'] ?? '');
    $telegramId = trim($_POST['telegram_id'] ?? '');
    $roleIdPost = (int)($_POST['role_id'] ?? 0);
    $isActive = isset($_POST['is_active']) ? 1 : 0;

    $locationId = (int)($_POST['location_id'] ?? 0);
    $workshopIds = isset($_POST['workshop_ids']) ? (array)$_POST['workshop_ids'] : [];

    if ($fullName === '') $errors[] = 'ФИО обязательно';
    if ($login === '') $errors[] = 'Логин обязателен';
    if ($roleIdPost <= 0) $errors[] = 'Роль обязательна';

    if ($userId === 0 && trim($password) === '') {
        $errors[] = 'Пароль обязателен при создании пользователя';
    }

    // проверка уникальности логина
    if (!$errors) {
        $loginSql = db_escape($login);
        $check = db_fetch_one("SELECT id FROM users WHERE login = '$loginSql' AND id <> $userId LIMIT 1");
        if ($check) {
            $errors[] = 'Такой логин уже существует';
        }
    }

    if (!$errors) {
        $fullNameSql = db_escape($fullName);
        $telegramSql = db_escape($telegramId);

        if ($userId > 0) {
            // обновление
            db_query("
                UPDATE users
                SET full_name = '$fullNameSql',
                    login = '$loginSql',
                    telegram_id = '$telegramSql',
                    role_id = $roleIdPost,
                    is_active = $isActive
                WHERE id = $userId
            ");

            if (trim($password) !== '') {
                $hash = password_hash($password, PASSWORD_DEFAULT);
                $hashSql = db_escape($hash);
                db_query("UPDATE users SET password_hash = '$hashSql' WHERE id = $userId");
            }
        } else {
            // создание
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $hashSql = db_escape($hash);

            db_query("
                INSERT INTO users (login, password_hash, full_name, role_id, telegram_id, is_active)
                VALUES ('$loginSql', '$hashSql', '$fullNameSql', $roleIdPost, '$telegramSql', $isActive)
            ");
            $userId = (int)db()->getLastInsertId();
        }

        // сохраняем локацию (0 = все -> удаляем привязку)
        db_query("DELETE FROM user_locations WHERE user_id = $userId");
        if ($locationId > 0) {
            db_query("INSERT INTO user_locations (user_id, location_id) VALUES ($userId, $locationId)");
        }

        // сохраняем цеха (пусто = все -> удаляем привязки)
        db_query("DELETE FROM user_workshops WHERE user_id = $userId");
        foreach ($workshopIds as $wid) {
            $wid = (int)$wid;
            if ($wid > 0) {
                db_query("INSERT INTO user_workshops (user_id, workshop_id) VALUES ($userId, $wid)");
            }
        }

        header('Location: users.php');
        exit;
    }

    // если ошибки — заполним обратно, чтобы не пропадало
    $user['full_name'] = $fullName;
    $user['login'] = $login;
    $user['telegram_id'] = $telegramId;
    $user['role_id'] = $roleIdPost;
    $user['is_active'] = $isActive;

    $currentLocationId = $locationId;
    $currentWorkshopIds = array_map('intval', $workshopIds);
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <a href="users.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">
                ← Назад к пользователям
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <?php if ($errors): ?>
                <div class="alert alert-danger">
                    <?php echo implode('<br>', $errors); ?>
                </div>
            <?php endif; ?>

            <form method="post">

                <div class="form-group" style="margin-bottom:12px;">
                    <label>ФИО</label>
                    <input type="text" name="full_name" class="form-control"
                           value="<?php echo htmlspecialchars($user['full_name'] ?? ''); ?>">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Логин</label>
                    <input type="text" name="login" class="form-control"
                           value="<?php echo htmlspecialchars($user['login'] ?? ''); ?>">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Пароль <?php echo ($userId > 0) ? '(оставь пустым, чтобы не менять)' : ''; ?></label>
                    <input type="password" name="password" class="form-control" value="">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>TG ID (telegram_id)</label>
                    <input type="text" name="telegram_id" class="form-control"
                           value="<?php echo htmlspecialchars($user['telegram_id'] ?? ''); ?>">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Роль</label>
                    <select name="role_id" class="form-control">
                        <option value="0">— выбери роль —</option>
                        <?php foreach ($roles as $r): ?>
                            <option value="<?php echo (int)$r['id']; ?>"
                                <?php echo ((int)($user['role_id'] ?? 0) === (int)$r['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($r['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Закрепленная локация (если не выбрать — видит все)</label>
                    <select name="location_id" class="form-control">
                        <option value="0">Все локации</option>
                        <?php foreach ($locations as $l): ?>
                            <option value="<?php echo (int)$l['id']; ?>"
                                <?php echo ($currentLocationId === (int)$l['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($l['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Закрепленные цеха (если не выбрать — видит все)</label>
                    <div style="margin-top:8px; max-height: 240px; overflow:auto; border: 1px solid rgba(0,0,0,0.1); padding: 8px; border-radius: 6px;">
                        <?php foreach ($workshops as $w): ?>
                            <?php
                                $wid = (int)$w['id'];
                                $checked = in_array($wid, $currentWorkshopIds, true);
                            ?>
                            <label style="display:block; margin-bottom:4px;">
                                <input type="checkbox" name="workshop_ids[]" value="<?php echo $wid; ?>" <?php echo $checked ? 'checked' : ''; ?>>
                                <?php echo htmlspecialchars($w['location_name'] . ' — ' . $w['name']); ?>
                            </label>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>
                        <input type="checkbox" name="is_active" value="1" <?php echo ((int)($user['is_active'] ?? 1) === 1) ? 'checked' : ''; ?>>
                        Активен
                    </label>
                </div>

                <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                    Сохранить
                </button>

            </form>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
