<?php
/**
 * Настройки → TG-бот
 * Файл: modules/settings/tg_bot.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

$errors = [];
$success = '';

function h($s) { return htmlspecialchars((string)$s); }

// Загружаем справочники
$users = db_fetch_all("
    SELECT id, full_name, login, telegram_id, is_active
    FROM users
    WHERE is_active = 1
    ORDER BY full_name
");

$roles = db_fetch_all("
    SELECT id, name, is_system
    FROM roles
    ORDER BY name
");

// Настройки (гарантируем наличие строк)
$ns = db_fetch_all("SELECT * FROM notification_settings");
$settingsByType = [];
foreach ($ns as $row) {
    $settingsByType[$row['notification_type']] = $row;
}

// если строк нет (на всякий случай) — создадим (send_time NOT NULL)
if (!isset($settingsByType['low_stock'])) {
    db_query("INSERT INTO notification_settings (notification_type, is_enabled, send_time) VALUES ('low_stock', 1, '09:00:00')");
    $settingsByType['low_stock'] = db_fetch_one("SELECT * FROM notification_settings WHERE notification_type='low_stock' LIMIT 1");
}
if (!isset($settingsByType['daily_report'])) {
    db_query("INSERT INTO notification_settings (notification_type, is_enabled, send_time) VALUES ('daily_report', 1, '18:00:00')");
    $settingsByType['daily_report'] = db_fetch_one("SELECT * FROM notification_settings WHERE notification_type='daily_report' LIMIT 1");
}

// Токен бота (одна строка)
$botRow = db_fetch_one("SELECT * FROM tg_bot_settings ORDER BY id LIMIT 1");
if (!$botRow) {
    // если вдруг таблица пустая
    db_query("INSERT INTO tg_bot_settings (bot_token) VALUES ('')");
    $botRow = db_fetch_one("SELECT * FROM tg_bot_settings ORDER BY id LIMIT 1");
}
$botToken = $botRow ? (string)$botRow['bot_token'] : '';

// Подписчики (пользователи)
$subsLowUsers = [];
$subsDailyUsers = [];
$rows = db_fetch_all("SELECT notification_type, user_id FROM notification_subscribers");
foreach ($rows as $r) {
    if ($r['notification_type'] === 'low_stock') $subsLowUsers[] = (int)$r['user_id'];
    if ($r['notification_type'] === 'daily_report') $subsDailyUsers[] = (int)$r['user_id'];
}

// Подписчики (роли) — таблица новая, но на странице не упадём, даже если её ещё не создали
$subsLowRoles = [];
$subsDailyRoles = [];
$roleSubsTableExists = true;
try {
    $rr = db_fetch_all("SELECT notification_type, role_id FROM notification_role_subscribers");
    foreach ($rr as $r) {
        if ($r['notification_type'] === 'low_stock') $subsLowRoles[] = (int)$r['role_id'];
        if ($r['notification_type'] === 'daily_report') $subsDailyRoles[] = (int)$r['role_id'];
    }
} catch (Exception $e) {
    // если таблицы ещё нет — просто не показываем данные ролей
    $roleSubsTableExists = false;
}

// Сохранение
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requirePermission('settings', 'edit');

    $botTokenNew = trim($_POST['bot_token'] ?? '');

    $lowEnabled = isset($_POST['low_stock_enabled']) ? 1 : 0;
    $dailyEnabled = isset($_POST['daily_report_enabled']) ? 1 : 0;

    // время (не обязательно менять, но поле NOT NULL — сохраняем корректно)
    $lowTime = trim($_POST['low_stock_time'] ?? ($settingsByType['low_stock']['send_time'] ?? '09:00:00'));
    $dailyTime = trim($_POST['daily_report_time'] ?? ($settingsByType['daily_report']['send_time'] ?? '18:00:00'));

    // подписчики-пользователи
    $lowUsers = isset($_POST['low_stock_users']) ? array_map('intval', (array)$_POST['low_stock_users']) : [];
    $dailyUsers = isset($_POST['daily_report_users']) ? array_map('intval', (array)$_POST['daily_report_users']) : [];

    // подписчики-роли
    $lowRoles = isset($_POST['low_stock_roles']) ? array_map('intval', (array)$_POST['low_stock_roles']) : [];
    $dailyRoles = isset($_POST['daily_report_roles']) ? array_map('intval', (array)$_POST['daily_report_roles']) : [];

    // простая проверка времени HH:MM или HH:MM:SS
    $timeOk = function($t) {
        return (bool)preg_match('/^\d{2}:\d{2}(:\d{2})?$/', $t);
    };
    if (!$timeOk($lowTime)) $errors[] = 'Время для "Минимальный остаток" должно быть в формате HH:MM';
    if (!$timeOk($dailyTime)) $errors[] = 'Время для "Дневной отчёт" должно быть в формате HH:MM';

    if (!$errors) {
        // токен
        $tokSql = db_escape($botTokenNew);
        db_query("UPDATE tg_bot_settings SET bot_token = '$tokSql' WHERE id = " . (int)$botRow['id']);

        // settings
        $lowTimeSql = db_escape(strlen($lowTime) === 5 ? $lowTime . ':00' : $lowTime);
        $dailyTimeSql = db_escape(strlen($dailyTime) === 5 ? $dailyTime . ':00' : $dailyTime);

        db_query("UPDATE notification_settings SET is_enabled = $lowEnabled, send_time = '$lowTimeSql' WHERE notification_type='low_stock'");
        db_query("UPDATE notification_settings SET is_enabled = $dailyEnabled, send_time = '$dailyTimeSql' WHERE notification_type='daily_report'");

        // subscribers users (перезаписываем)
        db_query("DELETE FROM notification_subscribers WHERE notification_type='low_stock'");
        foreach ($lowUsers as $uid) {
            if ($uid > 0) db_query("INSERT INTO notification_subscribers (notification_type, user_id) VALUES ('low_stock', $uid)");
        }

        db_query("DELETE FROM notification_subscribers WHERE notification_type='daily_report'");
        foreach ($dailyUsers as $uid) {
            if ($uid > 0) db_query("INSERT INTO notification_subscribers (notification_type, user_id) VALUES ('daily_report', $uid)");
        }

        // subscribers roles (если таблица есть)
        if ($roleSubsTableExists) {
            db_query("DELETE FROM notification_role_subscribers WHERE notification_type='low_stock'");
            foreach ($lowRoles as $rid) {
                if ($rid > 0) db_query("INSERT INTO notification_role_subscribers (notification_type, role_id) VALUES ('low_stock', $rid)");
            }

            db_query("DELETE FROM notification_role_subscribers WHERE notification_type='daily_report'");
            foreach ($dailyRoles as $rid) {
                if ($rid > 0) db_query("INSERT INTO notification_role_subscribers (notification_type, role_id) VALUES ('daily_report', $rid)");
            }
        }

        header('Location: tg_bot.php?saved=1');
        exit;
    }
}

// перезагрузка после сохранения
if (isset($_GET['saved'])) {
    $success = 'Настройки сохранены';
    $botRow = db_fetch_one("SELECT * FROM tg_bot_settings ORDER BY id LIMIT 1");
    $botToken = $botRow ? (string)$botRow['bot_token'] : '';

    $ns = db_fetch_all("SELECT * FROM notification_settings");
    $settingsByType = [];
    foreach ($ns as $row) $settingsByType[$row['notification_type']] = $row;

    $subsLowUsers = [];
    $subsDailyUsers = [];
    $rows = db_fetch_all("SELECT notification_type, user_id FROM notification_subscribers");
    foreach ($rows as $r) {
        if ($r['notification_type'] === 'low_stock') $subsLowUsers[] = (int)$r['user_id'];
        if ($r['notification_type'] === 'daily_report') $subsDailyUsers[] = (int)$r['user_id'];
    }

    $subsLowRoles = [];
    $subsDailyRoles = [];
    $roleSubsTableExists = true;
    try {
        $rr = db_fetch_all("SELECT notification_type, role_id FROM notification_role_subscribers");
        foreach ($rr as $r) {
            if ($r['notification_type'] === 'low_stock') $subsLowRoles[] = (int)$r['role_id'];
            if ($r['notification_type'] === 'daily_report') $subsDailyRoles[] = (int)$r['role_id'];
        }
    } catch (Exception $e) {
        $roleSubsTableExists = false;
    }
}

include '../../layout/header.php';
include '../../layout/sidebar.php';

$low = $settingsByType['low_stock'];
$daily = $settingsByType['daily_report'];

$lowEnabled = (int)($low['is_enabled'] ?? 1) === 1;
$dailyEnabled = (int)($daily['is_enabled'] ?? 1) === 1;

$lowTime = substr((string)($low['send_time'] ?? '09:00:00'), 0, 5);
$dailyTime = substr((string)($daily['send_time'] ?? '18:00:00'), 0, 5);
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display:flex; flex-wrap:wrap; gap:8px;">
                <a href="users.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Пользователи</a>
                <a href="roles.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Роли</a>
                <a href="locations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Локации</a>
                <a href="workshops.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Цеха</a>
                <a href="operations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Операции</a>
                <a href="material_categories.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Категории материалов</a>
                <a href="tg_bot.php" class="btn btn-primary" style="padding:6px 12px;font-size:13px;">TG-бот</a>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <div style="max-width:900px;">

                <?php if ($success): ?>
                    <div class="alert alert-success"><?php echo h($success); ?></div>
                <?php endif; ?>

                <?php if ($errors): ?>
                    <div class="alert alert-danger">
                        <?php echo implode('<br>', array_map('h', $errors)); ?>
                    </div>
                <?php endif; ?>

                <?php if (!$roleSubsTableExists): ?>
                    <div class="alert alert-warning">
                        Таблица подписок по ролям не найдена. Выполни SQL для создания notification_role_subscribers.
                    </div>
                <?php endif; ?>

                <form method="post">

                    <div class="form-group" style="margin-bottom:12px; max-width:600px;">
                        <label>Ключ Telegram-бота (токен)</label>
                        <input type="text" name="bot_token" class="form-control" value="<?php echo h($botToken); ?>" placeholder="Введите токен бота">
                    </div>

                    <hr style="margin:16px 0;">

                    <!-- low_stock -->
                    <div class="form-group" style="margin-bottom:12px;">
                        <label>
                            <input type="checkbox" name="low_stock_enabled" value="1" <?php echo $lowEnabled ? 'checked' : ''; ?>>
                            Уведомления о минимальном остатке
                        </label>
                        <div style="margin-top:8px; max-width:220px;">
                            <label style="font-size:13px; color:var(--text-secondary);">Время отправки</label>
                            <input type="time" name="low_stock_time" class="form-control" value="<?php echo h($lowTime); ?>">
                        </div>
                    </div>

                    <div style="display:flex; gap:16px; flex-wrap:wrap; margin-bottom:16px;">
                        <div style="flex:1; min-width:320px;">
                            <label>Кому отправлять (пользователи)</label>
                            <div style="margin-top:8px; max-height:240px; overflow:auto; border:1px solid rgba(0,0,0,0.1); padding:8px; border-radius:6px;">
                                <?php foreach ($users as $u): ?>
                                    <?php
                                        $uid = (int)$u['id'];
                                        $checked = in_array($uid, $subsLowUsers, true);
                                        $tg = trim((string)$u['telegram_id']);
                                        $tgNote = ($tg === '') ? ' — нет TG ID' : '';
                                    ?>
                                    <label style="display:block; margin-bottom:4px;">
                                        <input type="checkbox" name="low_stock_users[]" value="<?php echo $uid; ?>" <?php echo $checked ? 'checked' : ''; ?>>
                                        <?php echo h($u['full_name']); ?><?php echo h($tgNote); ?>
                                    </label>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <div style="flex:1; min-width:320px;">
                            <label>Кому отправлять (роли)</label>
                            <div style="margin-top:8px; max-height:240px; overflow:auto; border:1px solid rgba(0,0,0,0.1); padding:8px; border-radius:6px;">
                                <?php foreach ($roles as $r): ?>
                                    <?php
                                        $rid = (int)$r['id'];
                                        $checked = in_array($rid, $subsLowRoles, true);
                                    ?>
                                    <label style="display:block; margin-bottom:4px;">
                                        <input type="checkbox" name="low_stock_roles[]" value="<?php echo $rid; ?>" <?php echo $checked ? 'checked' : ''; ?>>
                                        <?php echo h($r['name']); ?>
                                    </label>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <hr style="margin:16px 0;">

                    <!-- daily_report -->
                    <div class="form-group" style="margin-bottom:12px;">
                        <label>
                            <input type="checkbox" name="daily_report_enabled" value="1" <?php echo $dailyEnabled ? 'checked' : ''; ?>>
                            Дневной отчёт
                        </label>
                        <div style="margin-top:8px; max-width:220px;">
                            <label style="font-size:13px; color:var(--text-secondary);">Время отправки</label>
                            <input type="time" name="daily_report_time" class="form-control" value="<?php echo h($dailyTime); ?>">
                        </div>
                    </div>

                    <div style="display:flex; gap:16px; flex-wrap:wrap; margin-bottom:16px;">
                        <div style="flex:1; min-width:320px;">
                            <label>Кому отправлять (пользователи)</label>
                            <div style="margin-top:8px; max-height:240px; overflow:auto; border:1px solid rgba(0,0,0,0.1); padding:8px; border-radius:6px;">
                                <?php foreach ($users as $u): ?>
                                    <?php
                                        $uid = (int)$u['id'];
                                        $checked = in_array($uid, $subsDailyUsers, true);
                                        $tg = trim((string)$u['telegram_id']);
                                        $tgNote = ($tg === '') ? ' — нет TG ID' : '';
                                    ?>
                                    <label style="display:block; margin-bottom:4px;">
                                        <input type="checkbox" name="daily_report_users[]" value="<?php echo $uid; ?>" <?php echo $checked ? 'checked' : ''; ?>>
                                        <?php echo h($u['full_name']); ?><?php echo h($tgNote); ?>
                                    </label>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <div style="flex:1; min-width:320px;">
                            <label>Кому отправлять (роли)</label>
                            <div style="margin-top:8px; max-height:240px; overflow:auto; border:1px solid rgba(0,0,0,0.1); padding:8px; border-radius:6px;">
                                <?php foreach ($roles as $r): ?>
                                    <?php
                                        $rid = (int)$r['id'];
                                        $checked = in_array($rid, $subsDailyRoles, true);
                                    ?>
                                    <label style="display:block; margin-bottom:4px;">
                                        <input type="checkbox" name="daily_report_roles[]" value="<?php echo $rid; ?>" <?php echo $checked ? 'checked' : ''; ?>>
                                        <?php echo h($r['name']); ?>
                                    </label>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                        Сохранить настройки
                    </button>

                </form>

            </div>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
