<?php
/**
 * Настройки → Роли
 * Файл: modules/settings/roles.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

// удаление роли (только не системной)
if (isset($_GET['delete'])) {
    $deleteId = (int)$_GET['delete'];

    $role = db_fetch_one("SELECT is_system FROM roles WHERE id = $deleteId");

    if ($role && (int)$role['is_system'] === 0) {
        db_query("DELETE FROM role_permissions WHERE role_id = $deleteId");
        db_query("DELETE FROM roles WHERE id = $deleteId");
    }

    header('Location: roles.php');
    exit;
}

// загрузка ролей
$roles = db_fetch_all("SELECT * FROM roles ORDER BY name");

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display:flex; flex-wrap:wrap; gap:8px;">
                <a href="users.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Пользователи</a>
                <a href="roles.php" class="btn btn-primary" style="padding:6px 12px;font-size:13px;">Роли</a>
                <a href="locations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Локации</a>
                <a href="workshops.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Цеха</a>
                <a href="operations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Операции</a>
                <a href="material_categories.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Категории материалов</a>
                <a href="tg_bot.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">TG-бот</a>
            </div>
        </div>
    </div>

    <!-- Кнопка добавления -->
    <div class="card" style="margin-bottom:12px;">
        <div class="card-body" style="padding:8px 12px;">
            <a href="role_edit.php" class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                Добавить роль
            </a>
        </div>
    </div>

    <!-- Таблица ролей -->
    <div class="card">
        <div class="card-body">

            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width:60px;">ID</th>
                        <th>Название роли</th>
                        <th style="width:160px;">Тип</th>
                        <th style="width:200px;">Действия</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!$roles): ?>
                        <tr>
                            <td colspan="4" style="text-align:center;color:var(--text-secondary);padding:20px;">
                                Ролей пока нет
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($roles as $role): ?>
                            <tr>
                                <td><?php echo (int)$role['id']; ?></td>
                                <td><?php echo htmlspecialchars($role['name']); ?></td>
                                <td><?php echo ((int)$role['is_system'] === 1) ? 'Системная' : 'Пользовательская'; ?></td>
                                <td>
                                    <a href="role_edit.php?id=<?php echo (int)$role['id']; ?>"
                                       class="btn btn-secondary"
                                       style="padding:4px 8px;font-size:12px;">
                                        Редактировать
                                    </a>

                                    <?php if ((int)$role['is_system'] === 0): ?>
                                        <a href="roles.php?delete=<?php echo (int)$role['id']; ?>"
                                           class="btn btn-danger"
                                           style="padding:4px 8px;font-size:12px;"
                                           onclick="return confirm('Удалить роль?');">
                                            Удалить
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
