<?php
/**
 * Настройки → Роли → Создание / редактирование
 * Файл: modules/settings/role_edit.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

$roleId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$errors = [];
$role = [
    'name' => '',
    'is_system' => 0
];

// Пункты меню (ТОЛЬКО view) — соответствуют sidebar.php
$menuView = [
    'dashboard'  => 'Дашборд',
    'materials'  => 'Материалы',
    'parts'      => 'Детали',
    'production' => 'Производство',
    'planfact'   => 'План/Факт',
    'warehouse'  => 'Склад',
    'quality'    => 'Качество',
    'personnel'  => 'Персонал',
    'finance'    => 'Финансы',
    'settings'   => 'Настройки',
];

// Права на изменения (edit) — это НЕ меню, а право редактировать
// Важно: здесь есть "settings edit", которое нужно для сохранения пользователей/ролей/настроек
$editActions = [
    'settings'   => 'Настройки — редактирование',
    'materials'  => 'Материалы — редактирование',
    'parts'      => 'Детали — редактирование',
    'production' => 'Производство — редактирование',
    'warehouse'  => 'Склад — редактирование',
    'quality'    => 'Качество — редактирование',
    'personnel'  => 'Персонал — редактирование',
];

// загрузка роли
if ($roleId > 0) {
    $role = db_fetch_one("SELECT * FROM roles WHERE id = $roleId");
    if (!$role) {
        die('Роль не найдена');
    }
}

// текущие права роли (view/edit)
$currentView = [];
$currentEdit = [];

if ($roleId > 0) {
    $rows = db_fetch_all("
        SELECT p.module, p.action
        FROM role_permissions rp
        JOIN permissions p ON p.id = rp.permission_id
        WHERE rp.role_id = $roleId
    ");

    foreach ($rows as $r) {
        if ($r['action'] === 'view') {
            $currentView[] = $r['module'];
        } elseif ($r['action'] === 'edit') {
            $currentEdit[] = $r['module'];
        }
    }
}

// сохранение
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $viewSelected = isset($_POST['perm_view']) ? (array)$_POST['perm_view'] : [];
    $editSelected = isset($_POST['perm_edit']) ? (array)$_POST['perm_edit'] : [];

    if ($name === '') {
        $errors[] = 'Название роли обязательно';
    }

    if (!$errors) {
        $nameSql = db_escape($name);

        if ($roleId > 0) {
            db_query("UPDATE roles SET name = '$nameSql' WHERE id = $roleId");
            db_query("DELETE FROM role_permissions WHERE role_id = $roleId");
        } else {
            db_query("INSERT INTO roles (name, is_system) VALUES ('$nameSql', 0)");
            $last = db_fetch_one("SELECT LAST_INSERT_ID() AS id");
            $roleId = $last ? (int)$last['id'] : 0;
        }

        // сохраняем VIEW
        foreach ($viewSelected as $module) {
            $module = trim((string)$module);
            if ($module === '' || !isset($menuView[$module])) continue;

            $moduleSql = db_escape($module);
            $perm = db_fetch_one("SELECT id FROM permissions WHERE module = '$moduleSql' AND action = 'view' LIMIT 1");
            if ($perm) {
                $pid = (int)$perm['id'];
                db_query("INSERT INTO role_permissions (role_id, permission_id) VALUES ($roleId, $pid)");
            }
        }

        // сохраняем EDIT
        foreach ($editSelected as $module) {
            $module = trim((string)$module);
            if ($module === '' || !isset($editActions[$module])) continue;

            $moduleSql = db_escape($module);
            $perm = db_fetch_one("SELECT id FROM permissions WHERE module = '$moduleSql' AND action = 'edit' LIMIT 1");
            if ($perm) {
                $pid = (int)$perm['id'];
                db_query("INSERT INTO role_permissions (role_id, permission_id) VALUES ($roleId, $pid)");
            }
        }

        header('Location: roles.php');
        exit;
    }

    // если ошибки — чтобы поля не пропали
    $role['name'] = $name;
    $currentView = $viewSelected;
    $currentEdit = $editSelected;
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <a href="roles.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">
                ← Назад к ролям
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <?php if ($errors): ?>
                <div class="alert alert-danger">
                    <?php echo implode('<br>', $errors); ?>
                </div>
            <?php endif; ?>

            <form method="post">

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Название роли</label>
                    <input type="text" name="name" class="form-control"
                           value="<?php echo htmlspecialchars($role['name'] ?? ''); ?>">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Доступные разделы меню</label>
                    <div style="margin-top:8px;">
                        <?php foreach ($menuView as $key => $label): ?>
                            <label style="display:block;">
                                <input type="checkbox" name="perm_view[]"
                                       value="<?php echo $key; ?>"
                                       <?php echo in_array($key, $currentView, true) ? 'checked' : ''; ?>>
                                <?php echo $label; ?>
                            </label>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Права на изменения</label>
                    <div style="margin-top:8px;">
                        <?php foreach ($editActions as $key => $label): ?>
                            <label style="display:block;">
                                <input type="checkbox" name="perm_edit[]"
                                       value="<?php echo $key; ?>"
                                       <?php echo in_array($key, $currentEdit, true) ? 'checked' : ''; ?>>
                                <?php echo $label; ?>
                            </label>
                        <?php endforeach; ?>
                    </div>
                    <div style="margin-top:8px; color: var(--text-secondary); font-size: 13px;">
                        Чтобы сохранять пользователей/роли в настройках — нужна галочка «Настройки — редактирование».
                    </div>
                </div>

                <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                    Сохранить
                </button>

            </form>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
