<?php
/**
 * Настройки → Операции
 * Файл: modules/settings/operations.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

function fmt_qty_local($v) {
    // на случай, если fmt_qty не подключена
    $s = (string)$v;
    if (strpos($s, '.') !== false) {
        $s = rtrim(rtrim($s, '0'), '.');
    }
    return $s;
}

// Реальное удаление операции
if (isset($_GET['delete'])) {
    requirePermission('settings', 'edit');

    $deleteId = (int)$_GET['delete'];
    if ($deleteId > 0) {
        db_query("DELETE FROM operation_materials WHERE operation_id = $deleteId");
        db_query("DELETE FROM operations WHERE id = $deleteId");
    }

    header('Location: operations.php');
    exit;
}

$operations = db_fetch_all("
    SELECT 
        o.id,
        o.name,
        o.price,
        o.daily_plan_per_employee,
        w.name AS workshop_name,
        (SELECT COUNT(*) FROM operation_materials om WHERE om.operation_id = o.id) AS materials_count
    FROM operations o
    JOIN workshops w ON w.id = o.workshop_id
    ORDER BY o.name
");

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display:flex; flex-wrap:wrap; gap:8px;">
                <a href="users.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Пользователи</a>
                <a href="roles.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Роли</a>
                <a href="locations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Локации</a>
                <a href="workshops.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Цеха</a>
                <a href="operations.php" class="btn btn-primary" style="padding:6px 12px;font-size:13px;">Операции</a>
                <a href="material_categories.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Категории материалов</a>
                <a href="tg_bot.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">TG-бот</a>
            </div>
        </div>
    </div>

    <!-- Кнопка -->
    <div class="card" style="margin-bottom:12px;">
        <div class="card-body" style="padding:8px 12px;">
            <a href="operation_edit.php" class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                Добавить операцию
            </a>
        </div>
    </div>

    <!-- Таблица -->
    <div class="card">
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width:60px;">ID</th>
                        <th>Название операции</th>
                        <th>Цех</th>
                        <th>Дневной план</th>
                        <th>Стоимость, ₽</th>
                        <th style="width:120px;">Материалов</th>
                        <th style="width:220px;">Действия</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!$operations): ?>
                        <tr>
                            <td colspan="7" style="text-align:center;color:var(--text-secondary);padding:20px;">
                                Операций пока нет
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($operations as $o): ?>
                            <tr>
                                <td><?php echo (int)$o['id']; ?></td>
                                <td><?php echo htmlspecialchars($o['name']); ?></td>
                                <td><?php echo htmlspecialchars($o['workshop_name']); ?></td>
                                <td><?php echo (int)$o['daily_plan_per_employee']; ?></td>
                                <td><?php echo htmlspecialchars($o['price']); ?></td>
                                <td><?php echo (int)$o['materials_count']; ?></td>
                                <td>
                                    <a href="operation_edit.php?id=<?php echo (int)$o['id']; ?>"
                                       class="btn btn-secondary"
                                       style="padding:4px 8px;font-size:12px;">
                                        Редактировать
                                    </a>

                                    <a href="operations.php?delete=<?php echo (int)$o['id']; ?>"
                                       class="btn btn-danger"
                                       style="padding:4px 8px;font-size:12px;"
                                       onclick="return confirm('Удалить операцию? Материалы операции также будут удалены.');">
                                        Удалить
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
