<?php
/**
 * Настройки → Категории материалов → Создание / редактирование
 * Файл: modules/settings/material_category_edit.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

$categoryId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$errors = [];
$cat = [
    'name' => '',
    'type' => 'material',
    'description' => '',
];

// загрузка
if ($categoryId > 0) {
    $row = db_fetch_one("SELECT * FROM material_categories WHERE id = $categoryId");
    if (!$row) {
        die('Категория не найдена');
    }
    $cat = $row;
}

// сохранение
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requirePermission('settings', 'edit');

    $name = trim($_POST['name'] ?? '');
    $type = trim($_POST['type'] ?? 'material');
    $description = trim($_POST['description'] ?? '');

    if ($name === '') $errors[] = 'Название категории обязательно';
    if (!in_array($type, ['material','tool','consumable'], true)) {
        $errors[] = 'Неверный тип категории';
    }

    if (!$errors) {
        $nameSql = db_escape($name);
        $typeSql = db_escape($type);
        $descSql = db_escape($description);

        if ($categoryId > 0) {
            db_query("
                UPDATE material_categories
                SET name = '$nameSql',
                    type = '$typeSql',
                    description = '$descSql'
                WHERE id = $categoryId
            ");
        } else {
            db_query("
                INSERT INTO material_categories (name, type, description)
                VALUES ('$nameSql', '$typeSql', '$descSql')
            ");
        }

        header('Location: material_categories.php');
        exit;
    }

    // чтобы не сбрасывалось при ошибке
    $cat['name'] = $name;
    $cat['type'] = $type;
    $cat['description'] = $description;
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <a href="material_categories.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">
                ← Назад к категориям
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <?php if ($errors): ?>
                <div class="alert alert-danger">
                    <?php echo implode('<br>', $errors); ?>
                </div>
            <?php endif; ?>

            <form method="post">

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Название категории</label>
                    <input type="text" name="name" class="form-control"
                           value="<?php echo htmlspecialchars($cat['name'] ?? ''); ?>">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Тип</label>
                    <select name="type" class="form-control">
                        <option value="material" <?php echo (($cat['type'] ?? 'material') === 'material') ? 'selected' : ''; ?>>Материал</option>
                        <option value="tool" <?php echo (($cat['type'] ?? '') === 'tool') ? 'selected' : ''; ?>>Инструмент</option>
                        <option value="consumable" <?php echo (($cat['type'] ?? '') === 'consumable') ? 'selected' : ''; ?>>Расходник</option>
                    </select>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Описание (не обязательно)</label>
                    <textarea name="description" class="form-control" rows="3"><?php
                        echo htmlspecialchars($cat['description'] ?? '');
                    ?></textarea>
                </div>

                <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                    Сохранить
                </button>

            </form>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
