<?php
/**
 * Настройки → Категории материалов
 * Файл: modules/settings/material_categories.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

// Реальное удаление категории
if (isset($_GET['delete'])) {
    requirePermission('settings', 'edit');

    $deleteId = (int)$_GET['delete'];
    if ($deleteId > 0) {
        // отвяжем items, чтобы не мешали ограничения/связи
        db_query("UPDATE items SET category_id = NULL WHERE category_id = $deleteId");
        // удаляем категорию
        db_query("DELETE FROM material_categories WHERE id = $deleteId");
    }

    header('Location: material_categories.php');
    exit;
}

// Список категорий
$categories = db_fetch_all("
    SELECT id, name, type
    FROM material_categories
    ORDER BY type, name
");

function typeLabel($type) {
    if ($type === 'material') return 'Материал';
    if ($type === 'tool') return 'Инструмент';
    if ($type === 'consumable') return 'Расходник';
    return $type;
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display:flex; flex-wrap:wrap; gap:8px;">
                <a href="users.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Пользователи</a>
                <a href="roles.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Роли</a>
                <a href="locations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Локации</a>
                <a href="workshops.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Цеха</a>
                <a href="operations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Операции</a>
                <a href="material_categories.php" class="btn btn-primary" style="padding:6px 12px;font-size:13px;">Категории материалов</a>
                <a href="tg_bot.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">TG-бот</a>
            </div>
        </div>
    </div>

    <!-- Кнопка -->
    <div class="card" style="margin-bottom:12px;">
        <div class="card-body" style="padding:8px 12px;">
            <a href="material_category_edit.php" class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                Добавить категорию
            </a>
        </div>
    </div>

    <!-- Таблица -->
    <div class="card">
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width:60px;">ID</th>
                        <th>Название категории</th>
                        <th style="width:160px;">Тип</th>
                        <th style="width:220px;">Действия</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!$categories): ?>
                        <tr>
                            <td colspan="4" style="text-align:center;color:var(--text-secondary);padding:20px;">
                                Категорий пока нет
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($categories as $c): ?>
                            <tr>
                                <td><?php echo (int)$c['id']; ?></td>
                                <td><?php echo htmlspecialchars($c['name']); ?></td>
                                <td><?php echo htmlspecialchars(typeLabel($c['type'])); ?></td>
                                <td>
                                    <a href="material_category_edit.php?id=<?php echo (int)$c['id']; ?>"
                                       class="btn btn-secondary"
                                       style="padding:4px 8px;font-size:12px;">
                                        Редактировать
                                    </a>

                                    <a href="material_categories.php?delete=<?php echo (int)$c['id']; ?>"
                                       class="btn btn-danger"
                                       style="padding:4px 8px;font-size:12px;"
                                       onclick="return confirm('Удалить категорию? У товаров/материалов эта категория будет очищена.');">
                                        Удалить
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
