<?php
/**
 * Настройки → Локации
 * Файл: modules/settings/locations.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

// Удаление (безопасное) = отключение
if (isset($_GET['delete'])) {
    requirePermission('settings', 'edit');

    $deleteId = (int)$_GET['delete'];
    if ($deleteId > 0) {
        db_query("UPDATE locations SET is_active = 0 WHERE id = $deleteId");
    }

    header('Location: locations.php');
    exit;
}

// Список локаций
$locations = db_fetch_all("
    SELECT id, name, address, is_active
    FROM locations
    ORDER BY name
");

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display:flex; flex-wrap:wrap; gap:8px;">
                <a href="users.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Пользователи</a>
                <a href="roles.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Роли</a>
                <a href="locations.php" class="btn btn-primary" style="padding:6px 12px;font-size:13px;">Локации</a>
                <a href="workshops.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Цеха</a>
                <a href="operations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Операции</a>
                <a href="material_categories.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">Категории материалов</a>
                <a href="tg_bot.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">TG-бот</a>
            </div>
        </div>
    </div>

    <!-- Кнопка -->
    <div class="card" style="margin-bottom:12px;">
        <div class="card-body" style="padding:8px 12px;">
            <a href="location_edit.php" class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                Добавить локацию
            </a>
        </div>
    </div>

    <!-- Таблица -->
    <div class="card">
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width:60px;">ID</th>
                        <th>Название</th>
                        <th>Адрес</th>
                        <th style="width:100px;">Статус</th>
                        <th style="width:220px;">Действия</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!$locations): ?>
                        <tr>
                            <td colspan="5" style="text-align:center;color:var(--text-secondary);padding:20px;">
                                Локаций пока нет
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($locations as $l): ?>
                            <tr>
                                <td><?php echo (int)$l['id']; ?></td>
                                <td><?php echo htmlspecialchars($l['name']); ?></td>
                                <td><?php echo htmlspecialchars($l['address'] ?? ''); ?></td>
                                <td><?php echo ((int)$l['is_active'] === 1) ? 'Активна' : 'Отключена'; ?></td>
                                <td>
                                    <a href="location_edit.php?id=<?php echo (int)$l['id']; ?>"
                                       class="btn btn-secondary"
                                       style="padding:4px 8px;font-size:12px;">
                                        Редактировать
                                    </a>

                                    <?php if ((int)$l['is_active'] === 1): ?>
                                        <a href="locations.php?delete=<?php echo (int)$l['id']; ?>"
                                           class="btn btn-danger"
                                           style="padding:4px 8px;font-size:12px;"
                                           onclick="return confirm('Отключить локацию?');">
                                            Удалить
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
