<?php
/**
 * Настройки → Локации → Создание / редактирование
 * Файл: modules/settings/location_edit.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

$locationId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$errors = [];
$location = [
    'name' => '',
    'address' => '',
    'is_active' => 1,
];

// загрузка
if ($locationId > 0) {
    $row = db_fetch_one("SELECT * FROM locations WHERE id = $locationId");
    if (!$row) {
        die('Локация не найдена');
    }
    $location = $row;
}

// сохранение
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requirePermission('settings', 'edit');

    $name = trim($_POST['name'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $isActive = isset($_POST['is_active']) ? 1 : 0;

    if ($name === '') $errors[] = 'Название обязательно';

    // проверка уникальности имени
    if (!$errors) {
        $nameSql = db_escape($name);
        $check = db_fetch_one("SELECT id FROM locations WHERE name = '$nameSql' AND id <> $locationId LIMIT 1");
        if ($check) {
            $errors[] = 'Локация с таким названием уже существует';
        }
    }

    if (!$errors) {
        $nameSql = db_escape($name);
        $addressSql = db_escape($address);

        if ($locationId > 0) {
            db_query("
                UPDATE locations
                SET name = '$nameSql',
                    address = '$addressSql',
                    is_active = $isActive
                WHERE id = $locationId
            ");
        } else {
            db_query("
                INSERT INTO locations (name, address, is_active)
                VALUES ('$nameSql', '$addressSql', $isActive)
            ");
        }

        header('Location: locations.php');
        exit;
    }

    // чтобы форма не очищалась при ошибке
    $location['name'] = $name;
    $location['address'] = $address;
    $location['is_active'] = $isActive;
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <a href="locations.php" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">
                ← Назад к локациям
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

            <?php if ($errors): ?>
                <div class="alert alert-danger">
                    <?php echo implode('<br>', $errors); ?>
                </div>
            <?php endif; ?>

            <form method="post">

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Название</label>
                    <input type="text" name="name" class="form-control"
                           value="<?php echo htmlspecialchars($location['name'] ?? ''); ?>">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Адрес</label>
                    <textarea name="address" class="form-control" rows="3"><?php
                        echo htmlspecialchars($location['address'] ?? '');
                    ?></textarea>
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>
                        <input type="checkbox" name="is_active" value="1" <?php echo ((int)($location['is_active'] ?? 1) === 1) ? 'checked' : ''; ?>>
                        Активна
                    </label>
                </div>

                <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                    Сохранить
                </button>

            </form>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
