<?php
/**
 * Модуль настроек - главная страница
 * Файл: modules/settings/index.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Панель разделов (sticky) -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display: flex; flex-wrap: wrap; gap: 8px;">
                <a href="users.php" class="btn btn-secondary" style="padding: 6px 12px; font-size: 13px;">Пользователи</a>
                <a href="roles.php" class="btn btn-secondary" style="padding: 6px 12px; font-size: 13px;">Роли</a>
                <a href="locations.php" class="btn btn-secondary" style="padding: 6px 12px; font-size: 13px;">Локации</a>
                <a href="workshops.php" class="btn btn-secondary" style="padding: 6px 12px; font-size: 13px;">Цеха</a>
                <a href="operations.php" class="btn btn-secondary" style="padding: 6px 12px; font-size: 13px;">Операции</a>
                <a href="material_categories.php" class="btn btn-secondary" style="padding: 6px 12px; font-size: 13px;">Категории материалов</a>
                <a href="tg_bot.php" class="btn btn-secondary" style="padding: 6px 12px; font-size: 13px;">TG-бот</a>
                <a href="logs.php" class="btn btn-secondary" style="padding: 6px 12px; font-size: 13px;">Логи</a>
            </div>
        </div>
    </div>

    <!-- Контент -->
    <div class="card">
        <div class="card-body">
            <p style="color: var(--text-secondary); font-size: 14px;">
                Выберите раздел настроек для управления параметрами системы.
            </p>
        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
