<?php
$q = trim($_GET['q'] ?? '');
$where = "1=1";
if ($q !== '') {
    $qLike = db_escape('%'.$q.'%');
    $where = "(p.name LIKE '$qLike' OR p.code LIKE '$qLike')";
}

$rows = db_fetch_all("
    SELECT p.*, w.name AS workshop_name
    FROM parts p
    LEFT JOIN workshops w ON w.id=p.workshop_id
    WHERE $where
    ORDER BY p.name
");
$canEdit = ACL::hasPermission($userId, 'parts', 'edit');
?>

<?php if ($canEdit): ?>
<div class="card" style="margin-bottom:12px;">
    <div class="card-body" style="padding:8px 12px;">
        <a href="part_edit.php" class="btn btn-success" style="padding:6px 12px;font-size:13px;">
            Добавить: Деталь
        </a>
    </div>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-body">

        <form method="get" style="display:flex;gap:8px;margin-bottom:10px;">
            <input type="hidden" name="tab" value="parts">
            <input name="q" class="form-control" placeholder="Поиск по коду или названию" value="<?php echo h($q); ?>">
            <button class="btn btn-secondary">Поиск</button>
        </form>

        <table class="table table-striped table-hover">
            <thead>
                <tr>
                    <th style="width:120px;">Код</th>
                    <th>Название</th>
                    <th style="width:220px;">Цех</th>
                    <th style="width:110px;">План</th>
                    <th style="width:220px;">Действия</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!$rows): ?>
                    <tr>
                        <td colspan="5" style="text-align:center;color:var(--text-secondary);padding:20px;">Деталей пока нет</td>
                    </tr>
                <?php else: ?>
                    <?php foreach($rows as $r): ?>
                        <tr>
                            <td><?php echo h($r['code']); ?></td>
                            <td><?php echo h($r['name']); ?></td>
                            <td><?php echo h($r['workshop_name']); ?></td>
                            <td><?php echo (int)$r['daily_plan']; ?></td>
                            <td>
                                <?php if ($canEdit): ?>
                                    <a class="btn btn-secondary" style="padding:4px 8px;font-size:12px;"
                                       href="part_edit.php?id=<?php echo (int)$r['id']; ?>">Редактировать</a>

                                    <a class="btn btn-danger" style="padding:4px 8px;font-size:12px;"
                                       href="part_delete.php?id=<?php echo (int)$r['id']; ?>"
                                       onclick="return confirm('Удалить деталь безвозвратно?');">Удалить</a>
                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>

    </div>
</div>
