<?php
require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('parts','edit');


function norm_num($s) {
    $s = trim((string)$s);
    if ($s === '') return 0;
    $s = str_replace(' ', '', $s);
    $s = str_replace(',', '.', $s);
    return (float)$s;
}


$id=(int)($_GET['id']??0);

if($_SERVER['REQUEST_METHOD']==='POST'){
 $name=db_escape($_POST['name']);
 $code=db_escape($_POST['code']);
 $ws=(int)$_POST['workshop_id'];
 $plan=(int)$_POST['daily_plan'];

 if($id){
  db_query("UPDATE parts SET name='$name',code='$code',workshop_id=$ws,daily_plan=$plan WHERE id=$id");
 }else{
  db_query("INSERT INTO parts (name,code,workshop_id,daily_plan) VALUES ('$name','$code',$ws,$plan)");
  $rowId = db_fetch_one("SELECT LAST_INSERT_ID() AS id");
  $id = (int)($rowId['id'] ?? 0);
  db_query("INSERT INTO part_specifications (part_id,version,effective_date) VALUES ($id,1,CURDATE())");
 }

 // материалы
 $specId = db_fetch_one("SELECT id FROM part_specifications WHERE part_id=$id")['id'];
 db_query("DELETE FROM part_materials WHERE specification_id=$specId");
 if(!empty($_POST['material_id'])){
  foreach($_POST['material_id'] as $k=>$mid){
   $qty = norm_num($_POST['material_qty'][$k] ?? '');
   if($mid && $qty>0){
    db_query("INSERT INTO part_materials (specification_id,item_id,quantity)
             VALUES ($specId,".(int)$mid.",$qty)");
   }
  }
 }

 // операции
 db_query("DELETE FROM part_operations WHERE specification_id=$specId");
 if(!empty($_POST['operation_id'])){
  foreach($_POST['operation_id'] as $k=>$oid){
   $seq=(int)$_POST['operation_seq'][$k];
   if($oid){
    db_query("INSERT INTO part_operations (specification_id,operation_id,sequence_number)
             VALUES ($specId,".(int)$oid.",$seq)");
   }
  }
 }

 header("Location: index.php");
 exit;
}

$part=$id?db_fetch_one("SELECT * FROM parts WHERE id=$id"):[];
$spec=$id?db_fetch_one("SELECT * FROM part_specifications WHERE part_id=$id"):null;

$materials=db_fetch_all("SELECT id,name FROM items WHERE item_type IN ('material','consumable') ORDER BY name");
$ops=db_fetch_all("SELECT id,name FROM operations ORDER BY name");

$pm=$spec?db_fetch_all("SELECT * FROM part_materials WHERE specification_id=".$spec['id']):[];
$po=$spec?db_fetch_all("SELECT * FROM part_operations WHERE specification_id=".$spec['id']." ORDER BY sequence_number"):[];

$workshops=db_fetch_all("SELECT id,name FROM workshops WHERE is_active=1");

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>
<main class="main-content">
<div class="card"><div class="card-body">
<form method="post">

<h4>Основные данные</h4>
<label>Код</label>
<input name="code" class="form-control" value="<?php echo htmlspecialchars($part['code']??''); ?>">

<label>Название</label>
<input name="name" required class="form-control" value="<?php echo htmlspecialchars($part['name']??''); ?>">

<label>Цех</label>
<select name="workshop_id" class="form-control">
<?php foreach($workshops as $w): ?>
<option value="<?php echo $w['id']; ?>" <?php if(($part['workshop_id']??0)==$w['id']) echo 'selected'; ?>>
<?php echo htmlspecialchars($w['name']); ?>
</option>
<?php endforeach; ?>
</select>

<label>План/день</label>
<input type="number" name="daily_plan" class="form-control" value="<?php echo (int)($part['daily_plan']??0); ?>">

<hr>
<h4>Материалы (на 1 деталь)</h4>
<?php for($i=0;$i<5;$i++): ?>
<div style="display:flex;gap:6px;margin-bottom:6px;">
 <select name="material_id[]" class="form-control">
  <option value="">—</option>
  <?php foreach($materials as $m): ?>
  <option value="<?php echo $m['id']; ?>" <?php if(($pm[$i]['item_id']??0)==$m['id']) echo 'selected'; ?>>
   <?php echo htmlspecialchars($m['name']); ?>
  </option>
  <?php endforeach; ?>
 </select>
 <input name="material_qty[]" class="form-control" placeholder="Кол-во"
  value="<?php echo $pm[$i]['quantity']??''; ?>">
</div>
<?php endfor; ?>

<hr>
<h4>Операции</h4>
<?php for($i=0;$i<5;$i++): ?>
<div style="display:flex;gap:6px;margin-bottom:6px;">
 <select name="operation_id[]" class="form-control">
  <option value="">—</option>
  <?php foreach($ops as $o): ?>
  <option value="<?php echo $o['id']; ?>" <?php if(($po[$i]['operation_id']??0)==$o['id']) echo 'selected'; ?>>
   <?php echo htmlspecialchars($o['name']); ?>
  </option>
  <?php endforeach; ?>
 </select>
 <input name="operation_seq[]" class="form-control" placeholder="Порядок"
  value="<?php echo $po[$i]['sequence_number']??($i+1); ?>">
</div>
<?php endfor; ?>

<br>
<button class="btn btn-primary">Сохранить</button>
<a href="index.php" class="btn btn-secondary">Отмена</a>

</form>
</div></div>
</main>
<?php include '../../layout/footer.php'; ?>
