<?php
require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('parts','view');

function h($s){ return htmlspecialchars((string)$s); }

$tab = $_GET['tab'] ?? 'parts';
if (!in_array($tab, ['parts','products'], true)) $tab = 'parts';

$userId = (int)($_SESSION['user_id'] ?? 0);

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>
<main class="main-content">

<!-- Sticky панель (как в Материалах) -->
<div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
  <div class="card-body" style="padding: 8px 12px;">
    <div style="display:flex; flex-wrap:wrap; gap:8px;">
      <a href="index.php?tab=parts"
         class="btn <?php echo $tab==='parts' ? 'btn-primary' : 'btn-secondary'; ?>"
         style="padding:6px 12px;font-size:13px;">Детали</a>

      <a href="index.php?tab=products"
         class="btn <?php echo $tab==='products' ? 'btn-primary' : 'btn-secondary'; ?>"
         style="padding:6px 12px;font-size:13px;">Готовые изделия</a>
    </div>
  </div>
</div>

<?php if (!empty($_GET['err'])): ?>
    <div class="alert alert-error" style="margin-bottom:12px;"><?php echo h($_GET['err']); ?></div>
<?php endif; ?>

<?php
if ($tab === 'products') {
    include 'products_list.php';
} else {
    include 'parts_list.php';
}
?>

</main>
<?php include '../../layout/footer.php'; ?>
