<?php
/**
 * Материалы → Создание / редактирование позиции (items)
 * Файл: modules/materials/item_edit.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('materials', 'view');

function h($s) { return htmlspecialchars((string)$s); }
function fmt_qty_local($v) {
    $s = (string)$v;
    if (strpos($s, '.') !== false) {
        $s = rtrim(rtrim($s, '0'), '.');
    }
    return $s === '' ? '0' : $s;
}

$userId = (int)($_SESSION['user_id'] ?? 0);

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$type = $_GET['type'] ?? 'material';
if (!in_array($type, ['material','tool','consumable'], true)) {
    $type = 'material';
}

function typeTitleOne($type) {
    if ($type === 'material') return 'Материал';
    if ($type === 'tool') return 'Инструмент';
    if ($type === 'consumable') return 'Расходник';
    return $type;
}

$errors = [];
$item = [
    'name' => '',
    'category_id' => null,
    'unit' => '',
    'item_type' => $type,
];

// видимые локации для минимумов
$visibleLocations = ACL::getUserLocations($userId);

// категории только нужного типа
$categories = db_fetch_all("
    SELECT id, name
    FROM material_categories
    WHERE type = '" . db_escape($type) . "'
    ORDER BY name
");

$minimums = []; // location_id => minimum_quantity

// загрузка
if ($id > 0) {
    $row = db_fetch_one("SELECT * FROM items WHERE id = $id LIMIT 1");
    if (!$row) {
        die('Позиция не найдена');
    }
    $item = $row;
    $type = $item['item_type']; // тип берём из БД

    // перечитаем категории под реальный тип
    $categories = db_fetch_all("
        SELECT id, name
        FROM material_categories
        WHERE type = '" . db_escape($type) . "'
        ORDER BY name
    ");

    // минимумы
    $mins = db_fetch_all("SELECT location_id, minimum_quantity FROM item_minimums WHERE item_id = $id");
    foreach ($mins as $m) {
        $minimums[(int)$m['location_id']] = fmt_qty_local($m['minimum_quantity']);
    }
}

// сохранение
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    requirePermission('materials', 'edit');

    $name = trim($_POST['name'] ?? '');
    $categoryId = ($_POST['category_id'] ?? '') === '' ? null : (int)$_POST['category_id'];
    $unit = trim($_POST['unit'] ?? '');

    if ($name === '') $errors[] = 'Название обязательно';
    if ($unit === '') $errors[] = 'Единица измерения обязательна';

    // минимумы по локациям
    $minsPosted = $_POST['min'] ?? [];
    $newMins = [];
    foreach ($visibleLocations as $loc) {
        $lid = (int)$loc['id'];
        $v = isset($minsPosted[$lid]) ? trim((string)$minsPosted[$lid]) : '';
        if ($v === '') continue;

        $vNorm = str_replace(',', '.', $v);
        if (!is_numeric($vNorm)) {
            $errors[] = 'Минимум должен быть числом';
            break;
        }
        $val = (float)$vNorm;
        if ($val < 0) {
            $errors[] = 'Минимум не может быть отрицательным';
            break;
        }
        $newMins[$lid] = $val;
    }

    // уникальность имени по типу (чтобы не было каши)
    // (если тебе нужно разрешить одинаковые названия — скажи, уберу)
    if (!$errors) {
        $nameSql = db_escape($name);
        $typeSql = db_escape($type);
        $chk = db_fetch_one("SELECT id FROM items WHERE item_type='$typeSql' AND name='$nameSql' AND id<>$id LIMIT 1");
        if ($chk) {
            $errors[] = 'Позиция с таким названием уже существует в этом разделе';
        }
    }

    if (!$errors) {
        $nameSql = db_escape($name);
        $unitSql = db_escape($unit);
        $typeSql = db_escape($type);

        $catSql = 'NULL';
        if ($categoryId !== null && $categoryId > 0) {
            $catSql = (string)(int)$categoryId;
        }

        if ($id > 0) {
            db_query("
                UPDATE items
                SET name = '$nameSql',
                    category_id = $catSql,
                    unit = '$unitSql'
                WHERE id = $id
            ");
        } else {
            // created_at в items уже с DEFAULT, но нам это не важно
            db_query("
                INSERT INTO items (item_type, name, category_id, unit, is_active)
                VALUES ('$typeSql', '$nameSql', $catSql, '$unitSql', 1)
            ");
            $last = db_fetch_one("SELECT LAST_INSERT_ID() AS id");
            $id = $last ? (int)$last['id'] : 0;
        }

        // перезаписываем минимумы только для видимых локаций
        if ($id > 0) {
            $locIds = array_map('intval', array_column($visibleLocations, 'id'));
            if ($locIds) {
                $locIdsStr = implode(',', $locIds);
                db_query("DELETE FROM item_minimums WHERE item_id = $id AND location_id IN ($locIdsStr)");
            }

            foreach ($newMins as $lid => $val) {
                $lid = (int)$lid;
                $valSql = db_escape(number_format($val, 2, '.', ''));
                db_query("
                    INSERT INTO item_minimums (item_id, location_id, minimum_quantity)
                    VALUES ($id, $lid, '$valSql')
                ");
            }
        }

        header('Location: index.php?type=' . urlencode($type));
        exit;
    }

    // вернуть значения в форму
    $item['name'] = $name;
    $item['category_id'] = $categoryId;
    $item['unit'] = $unit;

    $minimums = [];
    foreach ($newMins as $lid => $val) {
        $minimums[(int)$lid] = fmt_qty_local(number_format($val, 2, '.', ''));
    }
}

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <a href="index.php?type=<?php echo h($type); ?>" class="btn btn-secondary" style="padding:6px 12px;font-size:13px;">
                ← Назад: <?php echo h(typeTitleOne($type)); ?>
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body" style="max-width:900px;">

            <?php if ($errors): ?>
                <div class="alert alert-danger">
                    <?php echo implode('<br>', array_map('h', $errors)); ?>
                </div>
            <?php endif; ?>

            <form method="post">

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Название</label>
                    <input type="text" name="name" class="form-control" value="<?php echo h($item['name'] ?? ''); ?>">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Категория</label>
                    <select name="category_id" class="form-control">
                        <option value="">— не выбрано —</option>
                        <?php foreach ($categories as $c): ?>
                            <option value="<?php echo (int)$c['id']; ?>"
                                <?php echo ((string)($item['category_id'] ?? '') === (string)$c['id']) ? 'selected' : ''; ?>>
                                <?php echo h($c['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <div style="margin-top:6px;color:var(--text-secondary);font-size:13px;">
                        Категории берутся из “Категории материалов” и фильтруются по типу (материал/инструмент/расходник).
                    </div>
                </div>

                <div class="form-group" style="margin-bottom:12px; max-width:260px;">
                    <label>Единица измерения (шт/кг/м и т.п.)</label>
                    <input type="text" name="unit" class="form-control" value="<?php echo h($item['unit'] ?? ''); ?>">
                </div>

                <div class="form-group" style="margin-bottom:12px;">
                    <label>Складской минимум для TG-бота (по локациям)</label>

                    <div style="margin-top:8px; border:1px solid rgba(0,0,0,0.1); padding:8px; border-radius:6px;">
                        <?php if (!$visibleLocations): ?>
                            <div style="color:var(--text-secondary);padding:8px;">
                                Нет доступных локаций
                            </div>
                        <?php else: ?>
                            <?php foreach ($visibleLocations as $loc): ?>
                                <?php
                                    $lid = (int)$loc['id'];
                                    $val = $minimums[$lid] ?? '';
                                ?>
                                <div style="display:flex; gap:8px; align-items:center; margin-bottom:8px;">
                                    <div style="flex:1;">
                                        <?php echo h($loc['name']); ?>
                                    </div>
                                    <input type="text"
                                           name="min[<?php echo $lid; ?>]"
                                           class="form-control"
                                           style="width:200px;"
                                           placeholder="Минимум"
                                           value="<?php echo h($val); ?>">
                                </div>
                            <?php endforeach; ?>
                            <div style="color:var(--text-secondary);font-size:13px;">
                                Пустое поле — минимум не сохраняется. Значения отображаются без “.000”.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <button class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                    Сохранить
                </button>

            </form>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
