<?php
/**
 * Модуль: Материалы (items)
 * Файл: modules/materials/index.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('materials', 'view');

function h($s) { return htmlspecialchars((string)$s); }

// Кол-ва без .000 / .00
function fmt_qty_local($v) {
    $s = (string)$v;
    if (strpos($s, '.') !== false) {
        $s = rtrim(rtrim($s, '0'), '.');
    }
    return $s === '' ? '0' : $s;
}

// Тип вкладки
$type = $_GET['type'] ?? 'material';
if (!in_array($type, ['material','tool','consumable'], true)) {
    $type = 'material';
}

function typeTitle($type) {
    if ($type === 'material') return 'Материалы';
    if ($type === 'tool') return 'Инструменты';
    if ($type === 'consumable') return 'Расходники';
    return $type;
}

// Видимые локации (по закреплению пользователя)
$userId = (int)($_SESSION['user_id'] ?? 0);
$visibleLocations = ACL::getUserLocations($userId);
$visibleLocationIds = array_map('intval', array_column($visibleLocations, 'id'));
$locIdsStr = $visibleLocationIds ? implode(',', $visibleLocationIds) : '0';

// Удаление (реальное)
if (isset($_GET['delete'])) {
    requirePermission('materials', 'edit');

    $deleteId = (int)$_GET['delete'];
    if ($deleteId > 0) {

        // 1) минимумы
        db_query("DELETE FROM item_minimums WHERE item_id = $deleteId");

        // 2) материалы операций
        db_query("DELETE FROM operation_materials WHERE item_id = $deleteId");

        // 3) заказы материалов (если были)
        db_query("DELETE FROM material_orders WHERE item_id = $deleteId");

        // 4) движения склада (если были)
        // (на всякий случай чистим только связанные записи)
        db_query("DELETE FROM inventory_movements WHERE item_id = $deleteId");

        // 5) сам item
        db_query("DELETE FROM items WHERE id = $deleteId");
    }

    header('Location: index.php?type=' . urlencode($type));
    exit;
}

// Список items + минимум по видимым локациям (суммарно)
$sql = "
SELECT
    i.id,
    i.name,
    i.unit,
    i.item_type,
    mc.name AS category_name,
    COALESCE(SUM(CASE WHEN im.location_id IN ($locIdsStr) THEN im.minimum_quantity ELSE 0 END), 0) AS min_sum
FROM items i
LEFT JOIN material_categories mc ON mc.id = i.category_id
LEFT JOIN item_minimums im ON im.item_id = i.id
WHERE i.item_type = '" . db_escape($type) . "'
GROUP BY i.id, i.name, i.unit, i.item_type, mc.name
ORDER BY i.name
";

$items = db_fetch_all($sql);

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">

    <!-- Sticky панель -->
    <div class="card" style="position: sticky; top: 0; z-index: 10; margin-bottom: 16px;">
        <div class="card-body" style="padding: 8px 12px;">
            <div style="display:flex; flex-wrap:wrap; gap:8px;">
                <a href="index.php?type=material" class="btn <?php echo $type==='material' ? 'btn-primary' : 'btn-secondary'; ?>" style="padding:6px 12px;font-size:13px;">Материалы</a>
                <a href="index.php?type=tool" class="btn <?php echo $type==='tool' ? 'btn-primary' : 'btn-secondary'; ?>" style="padding:6px 12px;font-size:13px;">Инструменты</a>
                <a href="index.php?type=consumable" class="btn <?php echo $type==='consumable' ? 'btn-primary' : 'btn-secondary'; ?>" style="padding:6px 12px;font-size:13px;">Расходники</a>
            </div>
        </div>
    </div>

    <!-- Кнопка -->
    <div class="card" style="margin-bottom:12px;">
        <div class="card-body" style="padding:8px 12px;">
            <a href="item_edit.php?type=<?php echo h($type); ?>" class="btn btn-success" style="padding:6px 12px;font-size:13px;">
                Добавить: <?php echo h(typeTitle($type)); ?>
            </a>
        </div>
    </div>

    <!-- Таблица -->
    <div class="card">
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th style="width:60px;">ID</th>
                        <th>Название</th>
                        <th style="width:180px;">Категория</th>
                        <th style="width:100px;">Ед.</th>
                        <th style="width:170px;">Мин. остаток (сумма)</th>
                        <th style="width:220px;">Действия</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!$items): ?>
                        <tr>
                            <td colspan="6" style="text-align:center;color:var(--text-secondary);padding:20px;">
                                <?php echo h(typeTitle($type)); ?> пока нет
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($items as $it): ?>
                            <tr>
                                <td><?php echo (int)$it['id']; ?></td>
                                <td><?php echo h($it['name']); ?></td>
                                <td><?php echo h($it['category_name'] ?: '—'); ?></td>
                                <td><?php echo h($it['unit']); ?></td>
                                <td><?php echo h(fmt_qty_local($it['min_sum'])); ?></td>
                                <td>
                                    <a href="item_edit.php?id=<?php echo (int)$it['id']; ?>&type=<?php echo h($type); ?>"
                                       class="btn btn-secondary"
                                       style="padding:4px 8px;font-size:12px;">
                                        Редактировать
                                    </a>

                                    <?php if (ACL::hasPermission($userId, 'materials', 'edit')): ?>
                                        <a href="index.php?type=<?php echo h($type); ?>&delete=<?php echo (int)$it['id']; ?>"
                                           class="btn btn-danger"
                                           style="padding:4px 8px;font-size:12px;"
                                           onclick="return confirm('Удалить? Будут удалены минимумы, привязки в операциях, заказы и движения склада по этой позиции.');">
                                            Удалить
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

            <div style="margin-top:10px;color:var(--text-secondary);font-size:13px;">
                “Мин. остаток (сумма)” — это сумма минимумов по локациям, которые доступны тебе по закреплению.
                Минимум настраивается в карточке позиции.
            </div>

        </div>
    </div>

</main>

<?php include '../../layout/footer.php'; ?>
