<?php
/**
 * Управление цехами
 * Файл: modules/settings/workshops.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

$pageTitle = 'Цеха - ' . APP_NAME;
$userId = $_SESSION['user_id'];

$message = '';
$error = '';

// Обработка действий
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ACL::hasPermission($userId, 'settings', 'create')) {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'add') {
        $locationId = (int)($_POST['location_id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $description = trim($_POST['description'] ?? '');
        
        if ($locationId === 0 || empty($name)) {
            $error = 'Заполните все обязательные поля';
        } else {
            $nameEsc = db_escape($name);
            $descEsc = db_escape($description);
            
            $sql = "INSERT INTO workshops (location_id, name, description, is_active) 
                    VALUES ($locationId, '$nameEsc', '$descEsc', 1)";
            db_query($sql);
            $message = 'Цех успешно добавлен';
        }
    }
    
    if ($action === 'toggle') {
        $workshopId = (int)($_POST['workshop_id'] ?? 0);
        if ($workshopId > 0) {
            $current = db_fetch_one("SELECT is_active FROM workshops WHERE id = $workshopId")['is_active'];
            $new = $current ? 0 : 1;
            db_query("UPDATE workshops SET is_active = $new WHERE id = $workshopId");
            $message = $new ? 'Цех активирован' : 'Цех деактивирован';
        }
    }
}

// Получение цехов
$workshops = db_fetch_all("
    SELECT w.*, l.name as location_name,
           COUNT(DISTINCT uw.user_id) as users_count
    FROM workshops w
    JOIN locations l ON l.id = w.location_id
    LEFT JOIN user_workshops uw ON uw.workshop_id = w.id
    GROUP BY w.id
    ORDER BY l.name, w.name
");

// Получение локаций
$locations = db_fetch_all("SELECT * FROM locations WHERE is_active = 1 ORDER BY name");

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">
    <div class="breadcrumbs">
        <a href="<?php echo BASE_URL; ?>">Главная</a> / 
        <a href="index.php">Настройки</a> / 
        Цеха
    </div>
    
    <div class="page-header">
        <h1>⚙️ Цеха</h1>
        <p>Управление производственными цехами и участками</p>
    </div>
    
    <?php if ($message): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    
    <?php if ($error): ?>
        <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    
    <?php if (ACL::hasPermission($userId, 'settings', 'create')): ?>
    <div class="card">
        <div class="card-header">
            <h2>➕ Добавить цех</h2>
        </div>
        <div class="card-body">
            <form method="POST" action="">
                <input type="hidden" name="action" value="add">
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="location_id">Локация *</label>
                        <select id="location_id" name="location_id" class="form-control" required>
                            <option value="">Выберите локацию</option>
                            <?php foreach ($locations as $location): ?>
                                <option value="<?php echo $location['id']; ?>"><?php echo htmlspecialchars($location['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="name">Название цеха *</label>
                        <input type="text" id="name" name="name" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="description">Описание</label>
                        <input type="text" id="description" name="description" class="form-control">
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Добавить цех</button>
            </form>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="card">
        <div class="card-header">
            <h2>📋 Список цехов</h2>
        </div>
        <div class="card-body">
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Локация</th>
                            <th>Название цеха</th>
                            <th>Описание</th>
                            <th>Бригадиров</th>
                            <th>Статус</th>
                            <th>Действия</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($workshops as $workshop): ?>
                        <tr>
                            <td><?php echo $workshop['id']; ?></td>
                            <td><?php echo htmlspecialchars($workshop['location_name']); ?></td>
                            <td><strong><?php echo htmlspecialchars($workshop['name']); ?></strong></td>
                            <td><?php echo htmlspecialchars($workshop['description']); ?></td>
                            <td><span class="badge badge-info"><?php echo $workshop['users_count']; ?></span></td>
                            <td>
                                <?php if ($workshop['is_active']): ?>
                                    <span class="badge badge-success">Активен</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Неактивен</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if (ACL::hasPermission($userId, 'settings', 'update')): ?>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="action" value="toggle">
                                        <input type="hidden" name="workshop_id" value="<?php echo $workshop['id']; ?>">
                                        <button type="submit" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                                            <?php echo $workshop['is_active'] ? 'Деактивировать' : 'Активировать'; ?>
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<?php include '../../layout/footer.php'; ?>