<?php
/**
 * Управление ролями
 * Файл: modules/settings/roles.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

$pageTitle = 'Роли - ' . APP_NAME;
$userId = $_SESSION['user_id'];

$message = '';
$error = '';

// Обработка действий
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ACL::hasPermission($userId, 'settings', 'create')) {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'add') {
        $name = trim($_POST['name'] ?? '');
        $description = trim($_POST['description'] ?? '');
        
        if (empty($name)) {
            $error = 'Введите название роли';
        } else {
            $nameEsc = db_escape($name);
            $descEsc = db_escape($description);
            
            $sql = "INSERT INTO roles (name, description) VALUES ('$nameEsc', '$descEsc')";
            db_query($sql);
            $message = 'Роль успешно добавлена';
        }
    }
    
    if ($action === 'delete') {
        $roleId = (int)($_POST['role_id'] ?? 0);
        if ($roleId > 0) {
            // Проверка, что роль не используется
            $usersCount = db_fetch_one("SELECT COUNT(*) as count FROM users WHERE role_id = $roleId")['count'];
            if ($usersCount > 0) {
                $error = 'Невозможно удалить роль, так как она используется пользователями';
            } else {
                db_query("DELETE FROM role_permissions WHERE role_id = $roleId");
                db_query("DELETE FROM roles WHERE id = $roleId");
                $message = 'Роль удалена';
            }
        }
    }
}

// Получение ролей
$roles = db_fetch_all("
    SELECT r.*, COUNT(DISTINCT u.id) as users_count
    FROM roles r
    LEFT JOIN users u ON u.role_id = r.id
    GROUP BY r.id
    ORDER BY r.name
");

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">
    <div class="breadcrumbs">
        <a href="<?php echo BASE_URL; ?>">Главная</a> / 
        <a href="index.php">Настройки</a> / 
        Роли
    </div>
    
    <div class="page-header">
        <h1>🎭 Роли и права доступа</h1>
        <p>Управление ролями пользователей системы</p>
    </div>
    
    <?php if ($message): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    
    <?php if ($error): ?>
        <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    
    <?php if (ACL::hasPermission($userId, 'settings', 'create')): ?>
    <div class="card">
        <div class="card-header">
            <h2>➕ Добавить роль</h2>
        </div>
        <div class="card-body">
            <form method="POST" action="">
                <input type="hidden" name="action" value="add">
                
                <div style="display: grid; grid-template-columns: 1fr 2fr; gap: 20px;">
                    <div class="form-group">
                        <label for="name">Название роли *</label>
                        <input type="text" id="name" name="name" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="description">Описание</label>
                        <input type="text" id="description" name="description" class="form-control">
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Добавить роль</button>
            </form>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="card">
        <div class="card-header">
            <h2>📋 Список ролей</h2>
        </div>
        <div class="card-body">
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Название</th>
                            <th>Описание</th>
                            <th>Пользователей</th>
                            <th>Действия</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($roles as $role): ?>
                        <tr>
                            <td><?php echo $role['id']; ?></td>
                            <td><strong><?php echo htmlspecialchars($role['name']); ?></strong></td>
                            <td><?php echo htmlspecialchars($role['description']); ?></td>
                            <td><span class="badge badge-info"><?php echo $role['users_count']; ?></span></td>
                            <td>
                                <?php if (ACL::hasPermission($userId, 'settings', 'delete') && $role['users_count'] == 0): ?>
                                    <form method="POST" style="display: inline;" onsubmit="return confirm('Удалить роль?');">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="role_id" value="<?php echo $role['id']; ?>">
                                        <button type="submit" class="btn btn-danger" style="padding: 6px 12px; font-size: 12px;">Удалить</button>
                                    </form>
                                <?php else: ?>
                                    <span style="color: var(--text-secondary); font-size: 12px;">Используется</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h2>ℹ️ Описание ролей</h2>
        </div>
        <div class="card-body">
            <div style="display: grid; gap: 16px;">
                <div style="padding: 16px; background: var(--bg-secondary); border-radius: 8px;">
                    <h3 style="color: var(--text-primary); margin-bottom: 8px;">👑 Администратор</h3>
                    <p style="color: var(--text-secondary); font-size: 14px;">Полный доступ ко всем модулям системы, управление пользователями и настройками</p>
                </div>
                
                <div style="padding: 16px; background: var(--bg-secondary); border-radius: 8px;">
                    <h3 style="color: var(--text-primary); margin-bottom: 8px;">🎯 Директор</h3>
                    <p style="color: var(--text-secondary); font-size: 14px;">Доступ ко всем данным производства, финансам, отчетам по всем локациям</p>
                </div>
                
                <div style="padding: 16px; background: var(--bg-secondary); border-radius: 8px;">
                    <h3 style="color: var(--text-primary); margin-bottom: 8px;">⚙️ Начальник производства</h3>
                    <p style="color: var(--text-secondary); font-size: 14px;">Управление производством в своих локациях, контроль качества, план/факт</p>
                </div>
                
                <div style="padding: 16px; background: var(--bg-secondary); border-radius: 8px;">
                    <h3 style="color: var(--text-primary); margin-bottom: 8px;">👷 Бригадир</h3>
                    <p style="color: var(--text-secondary); font-size: 14px;">Учет операций в своих цехах, контроль работы бригады</p>
                </div>
                
                <div style="padding: 16px; background: var(--bg-secondary); border-radius: 8px;">
                    <h3 style="color: var(--text-primary); margin-bottom: 8px;">📦 Кладовщик</h3>
                    <p style="color: var(--text-secondary); font-size: 14px;">Управление складом, приход/расход материалов и деталей</p>
                </div>
                
                <div style="padding: 16px; background: var(--bg-secondary); border-radius: 8px;">
                    <h3 style="color: var(--text-primary); margin-bottom: 8px;">✓ Контролер ОТК</h3>
                    <p style="color: var(--text-secondary); font-size: 14px;">Контроль качества, регистрация брака и дефектов</p>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '../../layout/footer.php'; ?>