<?php
/**
 * Управление локациями
 * Файл: modules/settings/locations.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

requirePermission('settings', 'view');

$pageTitle = 'Локации - ' . APP_NAME;
$userId = $_SESSION['user_id'];

$message = '';
$error = '';

// Обработка действий
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ACL::hasPermission($userId, 'settings', 'create')) {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'add') {
        $name = trim($_POST['name'] ?? '');
        $address = trim($_POST['address'] ?? '');
        $description = trim($_POST['description'] ?? '');
        
        if (empty($name)) {
            $error = 'Введите название локации';
        } else {
            $nameEsc = db_escape($name);
            $addressEsc = db_escape($address);
            $descEsc = db_escape($description);
            
            $sql = "INSERT INTO locations (name, address, description, is_active) 
                    VALUES ('$nameEsc', '$addressEsc', '$descEsc', 1)";
            db_query($sql);
            $message = 'Локация успешно добавлена';
        }
    }
    
    if ($action === 'toggle') {
        $locationId = (int)($_POST['location_id'] ?? 0);
        if ($locationId > 0) {
            $current = db_fetch_one("SELECT is_active FROM locations WHERE id = $locationId")['is_active'];
            $new = $current ? 0 : 1;
            db_query("UPDATE locations SET is_active = $new WHERE id = $locationId");
            $message = $new ? 'Локация активирована' : 'Локация деактивирована';
        }
    }
}

// Получение локаций
$locations = db_fetch_all("
    SELECT l.*, 
           COUNT(DISTINCT w.id) as workshops_count,
           COUNT(DISTINCT ul.user_id) as users_count
    FROM locations l
    LEFT JOIN workshops w ON w.location_id = l.id AND w.is_active = 1
    LEFT JOIN user_locations ul ON ul.location_id = l.id
    GROUP BY l.id
    ORDER BY l.name
");

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">
    <div class="breadcrumbs">
        <a href="<?php echo BASE_URL; ?>">Главная</a> / 
        <a href="index.php">Настройки</a> / 
        Локации
    </div>
    
    <div class="page-header">
        <h1>🏭 Локации</h1>
        <p>Управление производственными площадками</p>
    </div>
    
    <?php if ($message): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    
    <?php if ($error): ?>
        <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    
    <?php if (ACL::hasPermission($userId, 'settings', 'create')): ?>
    <div class="card">
        <div class="card-header">
            <h2>➕ Добавить локацию</h2>
        </div>
        <div class="card-body">
            <form method="POST" action="">
                <input type="hidden" name="action" value="add">
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="name">Название *</label>
                        <input type="text" id="name" name="name" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="address">Адрес</label>
                        <input type="text" id="address" name="address" class="form-control">
                    </div>
                    
                    <div class="form-group">
                        <label for="description">Описание</label>
                        <input type="text" id="description" name="description" class="form-control">
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Добавить локацию</button>
            </form>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="card">
        <div class="card-header">
            <h2>📋 Список локаций</h2>
        </div>
        <div class="card-body">
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Название</th>
                            <th>Адрес</th>
                            <th>Описание</th>
                            <th>Цехов</th>
                            <th>Пользователей</th>
                            <th>Статус</th>
                            <th>Действия</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($locations as $location): ?>
                        <tr>
                            <td><?php echo $location['id']; ?></td>
                            <td><strong><?php echo htmlspecialchars($location['name']); ?></strong></td>
                            <td><?php echo htmlspecialchars($location['address']); ?></td>
                            <td><?php echo htmlspecialchars($location['description']); ?></td>
                            <td><span class="badge badge-info"><?php echo $location['workshops_count']; ?></span></td>
                            <td><span class="badge badge-info"><?php echo $location['users_count']; ?></span></td>
                            <td>
                                <?php if ($location['is_active']): ?>
                                    <span class="badge badge-success">Активна</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Неактивна</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if (ACL::hasPermission($userId, 'settings', 'update')): ?>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="action" value="toggle">
                                        <input type="hidden" name="location_id" value="<?php echo $location['id']; ?>">
                                        <button type="submit" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                                            <?php echo $location['is_active'] ? 'Деактивировать' : 'Активировать'; ?>
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<?php include '../../layout/footer.php'; ?>