<?php
/**
 * Модуль настроек - главная страница
 * Файл: modules/settings/index.php
 */

require_once '../../config.php';
require_once '../../auth/guard.php';
require_once '../../lib/db.php';
require_once '../../lib/acl.php';

// Проверка прав доступа
requirePermission('settings', 'view');

$pageTitle = 'Настройки - ' . APP_NAME;
$userId = $_SESSION['user_id'];

include '../../layout/header.php';
include '../../layout/sidebar.php';
?>

<main class="main-content">
    <div class="breadcrumbs">
        <a href="<?php echo BASE_URL; ?>">Главная</a> / Настройки
    </div>
    
    <div class="page-header">
        <h1>⚙️ Настройки системы</h1>
        <p>Управление пользователями, ролями, локациями и цехами</p>
    </div>
    
    <div class="stats-grid">
        <a href="users.php" class="stat-card" style="text-decoration: none; color: inherit;">
            <div class="stat-icon">👥</div>
            <div class="stat-info">
                <div class="stat-label">Пользователи</div>
                <div class="stat-value"><?php echo db_fetch_one("SELECT COUNT(*) as count FROM users")['count']; ?></div>
            </div>
        </a>
        
        <a href="roles.php" class="stat-card" style="text-decoration: none; color: inherit;">
            <div class="stat-icon">🎭</div>
            <div class="stat-info">
                <div class="stat-label">Роли</div>
                <div class="stat-value"><?php echo db_fetch_one("SELECT COUNT(*) as count FROM roles")['count']; ?></div>
            </div>
        </a>
        
        <a href="locations.php" class="stat-card" style="text-decoration: none; color: inherit;">
            <div class="stat-icon">🏭</div>
            <div class="stat-info">
                <div class="stat-label">Локации</div>
                <div class="stat-value"><?php echo db_fetch_one("SELECT COUNT(*) as count FROM locations WHERE is_active = 1")['count']; ?></div>
            </div>
        </a>
        
        <a href="workshops.php" class="stat-card" style="text-decoration: none; color: inherit;">
            <div class="stat-icon">⚙️</div>
            <div class="stat-info">
                <div class="stat-label">Цеха</div>
                <div class="stat-value"><?php echo db_fetch_one("SELECT COUNT(*) as count FROM workshops WHERE is_active = 1")['count']; ?></div>
            </div>
        </a>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h2>📋 Разделы настроек</h2>
        </div>
        <div class="card-body">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                <a href="users.php" style="text-decoration: none;">
                    <div class="card" style="margin: 0;">
                        <h3 style="color: var(--text-primary); margin-bottom: 10px;">👥 Пользователи</h3>
                        <p style="color: var(--text-secondary); font-size: 14px;">Управление учетными записями, права доступа, назначение ролей</p>
                    </div>
                </a>
                
                <a href="roles.php" style="text-decoration: none;">
                    <div class="card" style="margin: 0;">
                        <h3 style="color: var(--text-primary); margin-bottom: 10px;">🎭 Роли и права</h3>
                        <p style="color: var(--text-secondary); font-size: 14px;">Настройка ролей и прав доступа к модулям системы</p>
                    </div>
                </a>
                
                <a href="locations.php" style="text-decoration: none;">
                    <div class="card" style="margin: 0;">
                        <h3 style="color: var(--text-primary); margin-bottom: 10px;">🏭 Локации</h3>
                        <p style="color: var(--text-secondary); font-size: 14px;">Управление производственными площадками и их параметрами</p>
                    </div>
                </a>
                
                <a href="workshops.php" style="text-decoration: none;">
                    <div class="card" style="margin: 0;">
                        <h3 style="color: var(--text-primary); margin-bottom: 10px;">⚙️ Цеха</h3>
                        <p style="color: var(--text-secondary); font-size: 14px;">Настройка цехов, участков и производственных линий</p>
                    </div>
                </a>
            </div>
        </div>
    </div>
</main>

<?php include '../../layout/footer.php'; ?>