<?php
/**
 * Библиотека для работы с базой данных
 * Файл: lib/db.php
 */

class Database {
    private static $instance = null;
    private $connection = null;
    
    private function __construct() {
        $this->connect();
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function connect() {
        $this->connection = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        
        if (!$this->connection) {
            die('Ошибка подключения к базе данных: ' . mysqli_connect_error());
        }
        
        mysqli_set_charset($this->connection, DB_CHARSET);
    }
    
    public function getConnection() {
        return $this->connection;
    }
    
    public function query($sql) {
        $result = mysqli_query($this->connection, $sql);
        if (!$result) {
            if (DEBUG_MODE) {
                die('Ошибка выполнения запроса: ' . mysqli_error($this->connection) . '<br>SQL: ' . $sql);
            } else {
                die('Ошибка выполнения запроса');
            }
        }
        return $result;
    }
    
    public function prepare($sql) {
        $stmt = mysqli_prepare($this->connection, $sql);
        if (!$stmt) {
            if (DEBUG_MODE) {
                die('Ошибка подготовки запроса: ' . mysqli_error($this->connection) . '<br>SQL: ' . $sql);
            } else {
                die('Ошибка подготовки запроса');
            }
        }
        return $stmt;
    }
    
    public function escape($value) {
        return mysqli_real_escape_string($this->connection, $value);
    }
    
    public function fetchAll($result) {
        $rows = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $rows[] = $row;
        }
        return $rows;
    }
    
    public function fetchOne($result) {
        return mysqli_fetch_assoc($result);
    }
    
    public function getLastInsertId() {
        return mysqli_insert_id($this->connection);
    }
    
    public function affectedRows() {
        return mysqli_affected_rows($this->connection);
    }
    
    public function beginTransaction() {
        mysqli_begin_transaction($this->connection);
    }
    
    public function commit() {
        mysqli_commit($this->connection);
    }
    
    public function rollback() {
        mysqli_rollback($this->connection);
    }
    
    public function __destruct() {
        if ($this->connection) {
            mysqli_close($this->connection);
        }
    }
}

/**
 * Вспомогательные функции для работы с БД
 */
function db() {
    return Database::getInstance();
}

function db_query($sql) {
    return db()->query($sql);
}

function db_fetch_all($sql) {
    $result = db_query($sql);
    return db()->fetchAll($result);
}

function db_fetch_one($sql) {
    $result = db_query($sql);
    return db()->fetchOne($result);
}

function db_escape($value) {
    return db()->escape($value);
}
?>