<?php
/**
 * Библиотека для работы с правами доступа (ACL)
 * Файл: lib/acl.php
 */

class ACL {
    
    /**
     * Проверка прав доступа пользователя к модулю/действию
     */
    public static function hasPermission($userId, $module, $action = 'view') {
        $userId = (int)$userId;
        $module = db_escape($module);
        $action = db_escape($action);
        
        $sql = "SELECT COUNT(*) as count 
                FROM role_permissions rp
                JOIN permissions p ON rp.permission_id = p.id
                JOIN users u ON u.role_id = rp.role_id
                WHERE u.id = $userId 
                AND p.module = '$module' 
                AND p.action = '$action'";
        
        $result = db_fetch_one($sql);
        return $result['count'] > 0;
    }
    
    /**
     * Получить роль пользователя
     */
    public static function getUserRole($userId) {
        $userId = (int)$userId;
        
        $sql = "SELECT r.* 
                FROM roles r
                JOIN users u ON u.role_id = r.id
                WHERE u.id = $userId";
        
        return db_fetch_one($sql);
    }
    
    /**
     * Проверка, является ли пользователь администратором
     */
    public static function isAdmin($userId) {
        $role = self::getUserRole($userId);
        return $role && $role['name'] === 'Администратор';
    }
    
    /**
     * Проверка, является ли пользователь директором
     */
    public static function isDirector($userId) {
        $role = self::getUserRole($userId);
        return $role && $role['name'] === 'Директор';
    }
    
    /**
     * Получить локации пользователя
     */
    public static function getUserLocations($userId) {
        $userId = (int)$userId;
        
        // Администратор и директор видят все локации
        if (self::isAdmin($userId) || self::isDirector($userId)) {
            return db_fetch_all("SELECT * FROM locations WHERE is_active = 1");
        }
        
        $sql = "SELECT l.* 
                FROM locations l
                JOIN user_locations ul ON ul.location_id = l.id
                WHERE ul.user_id = $userId AND l.is_active = 1";
        
        return db_fetch_all($sql);
    }
    
    /**
     * Получить ID локаций пользователя
     */
    public static function getUserLocationIds($userId) {
        $locations = self::getUserLocations($userId);
        return array_column($locations, 'id');
    }
    
    /**
     * Получить цеха пользователя (для бригадира)
     */
    public static function getUserWorkshops($userId) {
        $userId = (int)$userId;
        
        // Администратор и директор видят все цеха
        if (self::isAdmin($userId) || self::isDirector($userId)) {
            return db_fetch_all("SELECT * FROM workshops WHERE is_active = 1");
        }
        
        // Начальник производства видит все цеха своих локаций
        $role = self::getUserRole($userId);
        if ($role && $role['name'] === 'Начальник производства') {
            $locationIds = self::getUserLocationIds($userId);
            if (empty($locationIds)) {
                return [];
            }
            $locationIdsStr = implode(',', $locationIds);
            return db_fetch_all("SELECT * FROM workshops WHERE location_id IN ($locationIdsStr) AND is_active = 1");
        }
        
        // Бригадир видит только свои цеха
        $sql = "SELECT w.* 
                FROM workshops w
                JOIN user_workshops uw ON uw.workshop_id = w.id
                WHERE uw.user_id = $userId AND w.is_active = 1";
        
        return db_fetch_all($sql);
    }
    
    /**
     * Проверка доступа к локации
     */
    public static function hasAccessToLocation($userId, $locationId) {
        $locationIds = self::getUserLocationIds($userId);
        return in_array($locationId, $locationIds);
    }
    
    /**
     * Проверка доступа к цеху
     */
    public static function hasAccessToWorkshop($userId, $workshopId) {
        $workshops = self::getUserWorkshops($userId);
        $workshopIds = array_column($workshops, 'id');
        return in_array($workshopId, $workshopIds);
    }
    
    /**
     * Получить SQL условие для фильтрации по локациям
     */
    public static function getLocationFilter($userId, $tableAlias = '') {
        if (self::isAdmin($userId) || self::isDirector($userId)) {
            return '1=1'; // Нет ограничений
        }
        
        $locationIds = self::getUserLocationIds($userId);
        if (empty($locationIds)) {
            return '1=0'; // Нет доступа
        }
        
        $locationIdsStr = implode(',', $locationIds);
        $prefix = $tableAlias ? $tableAlias . '.' : '';
        return "{$prefix}location_id IN ($locationIdsStr)";
    }
}
?>