<?php
/**
 * Боковое меню навигации
 * Файл: layout/sidebar.php
 */

require_once BASE_PATH . '/lib/acl.php';

$userId = $_SESSION['user_id'];
$currentModule = basename(dirname($_SERVER['PHP_SELF']));
?>

<aside class="sidebar" id="sidebar">
    <nav class="sidebar-nav">
        <ul class="nav-list">
            <li class="nav-item <?php echo $currentModule === 'dashboard' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/dashboard/">
                    <span class="icon">📊</span>
                    <span class="text">Дашборд</span>
                </a>
            </li>
            
            <?php if (ACL::hasPermission($userId, 'materials', 'view')): ?>
            <li class="nav-item <?php echo $currentModule === 'materials' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/materials/">
                    <span class="icon">📦</span>
                    <span class="text">Материалы</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (ACL::hasPermission($userId, 'parts', 'view')): ?>
            <li class="nav-item <?php echo $currentModule === 'parts' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/parts/">
                    <span class="icon">🔧</span>
                    <span class="text">Детали</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (ACL::hasPermission($userId, 'production', 'view')): ?>
            <li class="nav-item <?php echo $currentModule === 'production' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/production/">
                    <span class="icon">⚙️</span>
                    <span class="text">Производство</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (ACL::hasPermission($userId, 'planfact', 'view')): ?>
            <li class="nav-item <?php echo $currentModule === 'planfact' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/planfact/">
                    <span class="icon">📈</span>
                    <span class="text">План/Факт</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (ACL::hasPermission($userId, 'warehouse', 'view')): ?>
            <li class="nav-item <?php echo $currentModule === 'warehouse' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/warehouse/">
                    <span class="icon">🏪</span>
                    <span class="text">Склад</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (ACL::hasPermission($userId, 'quality', 'view')): ?>
            <li class="nav-item <?php echo $currentModule === 'quality' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/quality/">
                    <span class="icon">✓</span>
                    <span class="text">Качество</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (ACL::hasPermission($userId, 'personnel', 'view')): ?>
            <li class="nav-item <?php echo $currentModule === 'personnel' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/personnel/">
                    <span class="icon">👥</span>
                    <span class="text">Персонал</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (ACL::hasPermission($userId, 'finance', 'view')): ?>
            <li class="nav-item <?php echo $currentModule === 'finance' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/finance/">
                    <span class="icon">💰</span>
                    <span class="text">Финансы</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (ACL::hasPermission($userId, 'settings', 'view')): ?>
            <li class="nav-item <?php echo $currentModule === 'settings' ? 'active' : ''; ?>">
                <a href="<?php echo BASE_URL; ?>/modules/settings/">
                    <span class="icon">⚙️</span>
                    <span class="text">Настройки</span>
                </a>
            </li>
            <?php endif; ?>
        </ul>
    </nav>
</aside>