<?php
/**
 * Современная шапка сайта с переключателем темы
 * Файл: layout/header.php
 */
?>
<!DOCTYPE html>
<html lang="ru" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? APP_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <div class="wrapper">
        <header class="header">
            <div class="header-left">
                <button class="menu-toggle" onclick="toggleSidebar()" aria-label="Toggle menu">☰</button>
                <h1 class="logo"><?php echo APP_NAME; ?></h1>
            </div>
            <div class="header-right">
                <button class="theme-toggle" onclick="toggleTheme()" aria-label="Toggle theme"></button>
                <span class="user-info">
                    <?php echo htmlspecialchars($_SESSION['user_name']); ?> 
                    <small>(<?php echo htmlspecialchars($_SESSION['user_role']); ?>)</small>
                </span>
                <a href="<?php echo BASE_URL; ?>/auth/logout.php" class="btn-logout">Выход</a>
            </div>
        </header>
        
        <script>
            // Theme Toggle Function
            function toggleTheme() {
                const html = document.documentElement;
                const currentTheme = html.getAttribute('data-theme');
                const newTheme = currentTheme === 'light' ? 'dark' : 'light';
                
                html.setAttribute('data-theme', newTheme);
                localStorage.setItem('theme', newTheme);
                
                // Add animation
                document.body.style.transition = 'background 0.3s ease, color 0.3s ease';
            }
            
            // Load saved theme
            (function() {
                const savedTheme = localStorage.getItem('theme') || 'light';
                document.documentElement.setAttribute('data-theme', savedTheme);
            })();
            
            // Sidebar Toggle Function
            function toggleSidebar() {
                const sidebar = document.getElementById('sidebar');
                sidebar.classList.toggle('collapsed');
                
                // Save state
                const isCollapsed = sidebar.classList.contains('collapsed');
                localStorage.setItem('sidebarCollapsed', isCollapsed);
            }
            
            // Load sidebar state
            (function() {
                const isCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
                if (isCollapsed) {
                    document.getElementById('sidebar')?.classList.add('collapsed');
                }
            })();
        </script>