<?php
/**
 * Проверка авторизации и прав доступа
 * Файл: auth/guard.php
 * 
 * Подключать в начале каждой защищенной страницы
 */

session_start();

// Проверка авторизации
if (!isset($_SESSION['user_id'])) {
    header('Location: ' . BASE_URL . '/auth/login.php');
    exit;
}

// Проверка времени жизни сессии
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > SESSION_LIFETIME)) {
    session_destroy();
    header('Location: ' . BASE_URL . '/auth/login.php?timeout=1');
    exit;
}

$_SESSION['last_activity'] = time();

// Функция проверки прав доступа к модулю
function requirePermission($module, $action = 'view') {
    require_once BASE_PATH . '/lib/acl.php';
    
    if (!ACL::hasPermission($_SESSION['user_id'], $module, $action)) {
        http_response_code(403);
        die('
        <!DOCTYPE html>
        <html lang="ru">
        <head>
            <meta charset="UTF-8">
            <title>Доступ запрещен</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    min-height: 100vh;
                    margin: 0;
                    background: #f5f5f5;
                }
                .error-box {
                    background: white;
                    padding: 40px;
                    border-radius: 10px;
                    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
                    text-align: center;
                }
                h1 {
                    color: #c33;
                    margin-bottom: 20px;
                }
                p {
                    color: #666;
                    margin-bottom: 20px;
                }
                a {
                    display: inline-block;
                    padding: 10px 20px;
                    background: #667eea;
                    color: white;
                    text-decoration: none;
                    border-radius: 5px;
                }
            </style>
        </head>
        <body>
            <div class="error-box">
                <h1>Доступ запрещен</h1>
                <p>У вас нет прав для просмотра этой страницы.</p>
                <a href="' . BASE_URL . '/modules/dashboard/">Вернуться на главную</a>
            </div>
        </body>
        </html>
        ');
    }
}

// Функция получения текущего пользователя
function getCurrentUser() {
    static $user = null;
    
    if ($user === null) {
        require_once BASE_PATH . '/lib/db.php';
        $userId = $_SESSION['user_id'];
        $sql = "SELECT u.*, r.name as role_name 
                FROM users u 
                JOIN roles r ON u.role_id = r.id 
                WHERE u.id = $userId";
        $user = db_fetch_one($sql);
    }
    
    return $user;
}
?>