<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <a class="crumb" href="index.php?m=warehouse&a=index&type=<?= h($type) ?>">Склад</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Приход</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2"><?= h($title) ?></h2>
    <div class="muted">поставщик/накладная/цена партии</div>
  </div>

  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="post">
    <div class="form-grid">
      <div class="field">
        <label>Локация*</label>
        <select name="location_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($locations as $l): ?>
            <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$location_id===(int)$l['location_id']?'selected':'') ?>>
              <?= h($l['location_name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="field">
        <label>Позиция*</label>
        <select name="item_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($items as $it): ?>
            <option value="<?= (int)$it['id'] ?>"><?= h($it['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Количество*</label>
        <input name="qty" required placeholder="например: 10 или 2.5">
      </div>
      <div class="field">
        <label>Цена за единицу (цена партии)</label>
        <input name="unit_price" placeholder="например: 120.50">
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Поставщик (текст)</label>
        <input name="supplier" placeholder="например: ООО Рога и Копыта">
      </div>
      <div class="field">
        <label>Накладная №</label>
        <input name="invoice_no" placeholder="например: 123/А">
      </div>
    </div>

    <div class="field" style="margin-top:12px;">
      <label>Комментарий</label>
      <textarea name="comment"></textarea>
    </div>

    <div class="actions">
      <button class="btn primary" type="submit">Оприбытковать</button>
      <a class="btn" href="index.php?m=warehouse&a=index&type=<?= h($type) ?>">Назад</a>
    </div>
  </form>
</section>
