<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Склад</span>
</div>

<?php require __DIR__ . '/_tabs.php'; ?>

<section class="card">
  <div class="card-head">
    <h2 class="h2"><?= h($title) ?></h2>
    <div class="muted">остатки по локации (журнал движений)</div>
  </div>

  <div class="actions">
    <a class="btn primary" href="index.php?m=warehouse&a=receipt&type=<?= h($type) ?>">+ Приход</a>
    <a class="btn" href="index.php?m=warehouse&a=transfer&type=<?= h($type) ?>">Перемещение</a>
    <a class="btn" href="index.php?m=warehouse&a=adjust&type=<?= h($type) ?>">Корректировка</a>
    <?php if (in_array($type, ['tool','consumable'], true)): ?>
      <a class="btn danger" href="index.php?m=warehouse&a=writeoff&type=<?= h($type) ?>">Списать</a>
    <?php endif; ?>
  </div>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="warehouse">
    <input type="hidden" name="a" value="index">
    <input type="hidden" name="type" value="<?= h($type) ?>">

    <select name="location_id">
      <option value="0">Локация: (не выбрано)</option>
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$location_id===(int)$l['location_id']?'selected':'') ?>>
          <?= h($l['location_name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <input name="q" placeholder="Поиск: название или код" value="<?= h($q) ?>">
    <button class="btn" type="submit">Показать</button>
  </form>

  <div class="small" style="margin-top:10px;">
    Выберите локацию, чтобы увидеть остатки. Остаток считается по журналу движений (приход/перемещения/списания/корректировки).
  </div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Наименование</th>
          <th>Код</th>
          <th>Остаток</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($items as $it): ?>
        <tr>
          <td><b><?= h($it['name']) ?></b></td>
          <td class="muted"><?= h($it['code']) ?></td>
          <td><?= (int)$location_id>0 ? h($it['qty']) : '—' ?></td>
          <td style="white-space:nowrap;">
            <?php if ((int)$location_id>0): ?>
              <a class="btn" href="index.php?m=warehouse&a=details&type=<?= h($type) ?>&id=<?= (int)$it['id'] ?>&location_id=<?= (int)$location_id ?>">Детализация</a>
            <?php else: ?>
              <span class="small muted">выберите локацию</span>
            <?php endif; ?>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($items)===0): ?>
        <tr><td colspan="4" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>
