<?php
// views/staff/edit.php
$item = $item ?? [];
$item = array_merge([
  'id'=>0,
  'emp_no'=>'',
  'full_name'=>'',
  'phone'=>'',
  'birth_date'=>'',
  'hired_date'=>'',
  'photo_path'=>'',
  'location_id'=>0,
  'workshop_id'=>0,
  'is_active'=>1
], is_array($item) ? $item : []);

$id = (int)($item['id'] ?? 0);
$loc_id = (int)($item['location_id'] ?? 0);
$ws_id  = (int)($item['workshop_id'] ?? 0);
?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <a class="crumb" href="index.php?m=staff&a=index">Персонал</a>
  <span class="crumb-sep">/</span>
  <span class="crumb"><?= $id>0 ? 'Редактирование' : 'Создание' ?></span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2"><?= $id>0 ? 'Сотрудник' : 'Новый сотрудник' ?></h2>
    <div class="muted">карточка работника</div>
  </div>

  <?php if (!empty($ok)): ?>
    <div class="alert" style="border-color: rgba(25,195,125,.35);">Сохранено.</div>
  <?php endif; ?>
  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="post" enctype="multipart/form-data">
    <div class="form-grid">
      <div class="field">
        <label>Номер</label>
        <input name="emp_no" value="<?= h($item['emp_no']) ?>" placeholder="например: 1001">
      </div>

      <div class="field">
        <label>ФИО*</label>
        <input name="full_name" value="<?= h($item['full_name']) ?>" required>
      </div>

      <div class="field">
        <label>Телефон</label>
        <input name="phone" value="<?= h($item['phone']) ?>">
      </div>

      <div class="field">
        <label>Фото</label>
        <input type="file" name="photo" accept="image/*">
        <?php if (!empty($item['photo_path'])): ?>
          <div class="small" style="margin-top:8px;">
            <img src="<?= h($item['photo_path']) ?>"
                 alt="Фото"
                 style="max-height:140px; max-width:180px; border-radius:12px; border:1px solid rgba(255,255,255,.12); object-fit:contain; background:rgba(255,255,255,.06);">
            <div style="margin-top:8px; display:flex; gap:8px; align-items:center;">
              <button class="btn sm danger" type="submit" name="photo_delete" value="1" onclick="return confirm('Удалить фото сотрудника?');">Удалить фото</button>
              <span class="muted small">Фото удалится сразу после сохранения</span>
            </div>
          </div>
        <?php endif; ?>
      </div>

      <div class="field">
        <label>Дата рождения</label>
        <input type="date" name="birth_date" value="<?= h($item['birth_date']) ?>">
      </div>

      <div class="field">
        <label>Дата приёма</label>
        <input type="date" name="hired_date" value="<?= h($item['hired_date']) ?>">
      </div>

      <div class="field">
        <label>Локация*</label>
        <select name="location_id" required>
          <option value="0">— выберите —</option>
          <?php foreach (($locations ?? []) as $l): ?>
            <option value="<?= (int)$l['id'] ?>" <?= ($loc_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="field">
        <label>Цех*</label>
        <select name="workshop_id" required>
          <option value="0">— выберите —</option>
          <?php foreach (($workshops ?? []) as $w): ?>
            <option value="<?= (int)$w['id'] ?>" <?= ($ws_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="field">
        <label>Статус</label>
        <select name="is_active">
          <option value="1" <?= ((int)$item['is_active']===1?'selected':'') ?>>активен</option>
          <option value="0" <?= ((int)$item['is_active']===0?'selected':'') ?>>уволен/неактивен</option>
        </select>
      </div><?php if (in_array(($u['role'] ?? ''), ['admin','director'], true)): ?>
<div class="field">
  <label>Бригадир: оклад, ₽ (за период)</label>
  <input name="brigadier_base_salary" value="<?= h($item['brigadier_base_salary'] ?? '0') ?>" placeholder="например: 20000">
</div>
<div class="field">
  <label>Бригадир: % от выработки цеха</label>
  <input name="brigadier_percent" value="<?= h($item['brigadier_percent'] ?? '0') ?>" placeholder="например: 5">
  <div class="muted small">% считается от выработки сотрудников цеха (без собственной выработки)</div>
</div>
<?php endif; ?>


    </div>

    <div class="actions" style="margin-top:12px;">
      <button class="btn primary" type="submit">Сохранить</button>
      <?php if ($id>0): ?>
        <a class="btn" href="index.php?m=staff&a=badge&id=<?= (int)$id ?>" target="_blank">Бейдж</a>
      <?php endif; ?>
      <a class="btn" href="index.php?m=staff&a=index">Назад</a>
    </div>
  </form>

  <?php if ($id>0 && !empty($item['photo_path'])): ?>
    <!-- ВАЖНО: отдельная форма (не внутри формы сохранения), иначе браузер игнорирует POST -->
  <?php endif; ?>

  <?php if ($id>0): ?>
    <div class="hr"></div>

    <section class="card soft">
      <div class="card-head">
        <h2 class="h2">Инструмент сотрудника</h2>
        <div class="muted">выдача / возврат / списание. История хранится.</div>
      </div>

      <?php
        $tools = function_exists('staff_employee_tools') ? staff_employee_tools((int)$id, (int)$loc_id) : [];
        $tools_all = db_fetch_all(db_query("SELECT t.id, t.name FROM tools t ORDER BY t.name"));
        $events = db_fetch_all(db_query("SELECT e.*, t.name AS tool_name, u.full_name AS user_name
                                        FROM employee_tool_events e
                                        JOIN tools t ON t.id=e.tool_id
                                        LEFT JOIN users u ON u.id=e.created_by
                                        WHERE e.employee_id=".(int)$id." ORDER BY e.id DESC LIMIT 50"));
      ?>

      <div class="table-wrap">
        <table>
          <thead><tr><th>Наименование</th><th>Кол-во</th></tr></thead>
          <tbody>
            <?php foreach ($tools as $t): ?>
              <tr><td><b><?= h($t['name']) ?></b></td><td><?= h($t['qty']) ?></td></tr>
            <?php endforeach; ?>
            <?php if (count($tools)===0): ?>
              <tr><td colspan="2" class="muted">Инструмент не закреплён</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <form method="post" action="index.php?m=staff&a=tool_action" style="margin-top:12px;">
        <input type="hidden" name="employee_id" value="<?= (int)$id ?>">
        <div class="form-grid">
          <div class="field">
            <label>Действие*</label>
            <select name="action" required>
              <option value="issue">Выдать</option>
              <option value="return">Вернуть</option>
              <option value="writeoff">Списать</option>
            </select>
          </div>
          <div class="field">
            <label>Инструмент*</label>
            <select name="tool_id" required>
              <option value="0">— выберите —</option>
              <?php foreach ($tools_all as $tt): ?>
                <option value="<?= (int)$tt['id'] ?>"><?= h($tt['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="field">
            <label>Кол-во*</label>
            <input name="qty" value="1">
          </div>
        </div>

        <div class="form-grid" style="margin-top:12px;">
          <div class="field">
            <label>Причина (для списания обязательно)</label>
            <input name="reason" placeholder="например: износ">
          </div>
          <div class="field">
            <label>Комментарий</label>
            <input name="comment" placeholder="">
          </div>
        </div>

        <div class="actions" style="margin-top:12px;">
          <button class="btn primary" type="submit">Выполнить</button>
        </div>
      </form>

      <div class="hr"></div>

      <div class="card-head">
        <h2 class="h2">История (последние 50)</h2>
        <div class="muted">кто и что сделал</div>
      </div>

      <div class="table-wrap">
        <table>
          <thead>
            <tr>
              <th>Дата</th><th>Событие</th><th>Инструмент</th><th>Кол-во</th><th>Причина</th><th>Кто</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($events as $ev): ?>
              <tr>
                <td class="muted"><?= h($ev['created_at']) ?></td>
                <td><b><?= h($ev['event_type']) ?></b></td>
                <td><?= h($ev['tool_name']) ?></td>
                <td><?= h($ev['qty']) ?></td>
                <td class="muted"><?= h($ev['reason']) ?></td>
                <td class="muted"><?= h($ev['user_name'] ?? '') ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (count($events)===0): ?>
              <tr><td colspan="6" class="muted">История пустая</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </section>
  <?php endif; ?>
</section>
