<?php $tab='locations'; require __DIR__ . '/_tabs.php'; ?>

<div class="card">
  <div class="card-head">
    <h2 class="h2">Цех</h2>
    <div class="muted"><?= !empty($item) ? 'редактирование' : 'создание' ?></div>
  </div>

  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="post">
    <div class="form-grid">
      <div class="field">
        <label>Наименование цеха*</label>
        <input name="name" required value="<?= h($item['name'] ?? '') ?>" placeholder="например: Мехобработка">
      </div>

      <div class="field">
        <label>Локация (не обязательно)</label>
        <select name="location_id">
          <option value="0">— не выбирать —</option>
          <?php foreach ($locations as $l): ?>
            <option value="<?= (int)$l['id'] ?>" <?= ((int)($item['location_id'] ?? 0)===(int)$l['id']?'selected':'') ?>>
              <?= h($l['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
        <?php if (empty($item)): ?>
          <label style="margin-top:10px; display:flex; gap:10px; align-items:center;">
            <input type="checkbox" name="apply_all_locations" value="1" checked>
            <span>Создать во всех локациях</span>
          </label>
        <?php endif; ?>
        <?php if (!empty($item)): ?>
          <div class="small">Для редактирования существующего цеха локация обязательна (это цех конкретной локации).</div>
        <?php endif; ?>
      </div>
    </div>

    <div class="actions">
      <button class="btn primary" type="submit">Сохранить</button>
      <a class="btn" href="index.php?m=settings&a=locations">Назад</a>
    </div>
  </form>
</div>
