<?php $tab='users'; require __DIR__ . '/_tabs.php'; ?>
<div class="card">
  <div class="card-head">
    <h2 class="h2">Настройки → Пользователь</h2>
    <div class="muted"><?= !empty($item) ? 'редактирование' : 'создание' ?></div>
  </div>

  <?php if (!empty($msg)): ?>
    <div class="alert"><?= h($msg) ?></div>
  <?php endif; ?>

  <form method="post">
    <div class="form-grid">
      <div class="field">
        <label>Логин*</label>
        <input name="login" required value="<?= h($item['login'] ?? '') ?>">
      </div>
      <div class="field">
        <label>Пароль <?= !empty($item)?'(оставьте пустым, чтобы не менять)':'(если пусто — будет admin123)' ?></label>
        <input name="password" type="password" value="">
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>ФИО*</label>
        <input name="full_name" required value="<?= h($item['full_name'] ?? '') ?>">
      </div>
      <div class="field">
        <label>Должность</label>
        <input name="position" value="<?= h($item['position'] ?? '') ?>">
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Роль*</label>
        <select name="role" required>
          <option value="">— выберите —</option>
          <?php foreach ($roles as $k=>$v): ?>
            <option value="<?= h($k) ?>" <?= (($item['role'] ?? '')===$k?'selected':'') ?>><?= h($v) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="field">
        <label>Telegram ID</label>
        <input name="telegram_id" value="<?= h($item['telegram_id'] ?? '') ?>">
      </div>
    </div>

    <div class="field" style="margin-top:12px;">
      <label><input type="checkbox" name="is_active" value="1" <?= ((int)($item['is_active'] ?? 1)===1?'checked':'') ?>> Активен</label>
    </div>

    <div class="hr"></div>

    <div class="field">
      <label>Доступные локации (можно несколько)</label>
      <div class="tabs">
        <?php foreach ($locations as $l): ?>
          <?php $checked = in_array((int)$l['id'], $selected_locations, true); ?>
          <label class="pill" style="cursor:pointer;">
            <input type="checkbox" name="locations[]" value="<?= (int)$l['id'] ?>" <?= ($checked?'checked':'') ?>>
            <?= h($l['name']) ?>
          </label>
        <?php endforeach; ?>
        <?php if (count($locations)===0): ?>
          <div class="small">Сначала создайте локации</div>
        <?php endif; ?>
      </div>
    </div>

    <div class="actions">
      <button class="btn primary" type="submit">Сохранить</button>
      <a class="btn" href="index.php?m=settings&a=users">Назад</a>
    </div>
  </form>
</div>
