<?php require __DIR__ . '/_tabs.php'; ?>
<?php
$roles = [
  'admin'=>'Администратор',
  'director'=>'Директор',
  'prod_head'=>'Нач. производства',
  'brigadier'=>'Бригадир',
  'storekeeper'=>'Кладовщик',
  'otk'=>'ОТК'
];
$keys = [
  'low_material'=>'Низкий остаток материала',
  'daily_products'=>'Ежедневный отчёт (готовые изделия)'
];
?>
<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Настройки</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Уведомления Telegram</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Уведомления (Telegram)</h2>
    <div class="muted">Включение/выключение по ролям и пользователям. Время нужно только для ежедневного отчёта.</div>
  </div>

  <form method="post">
    <input type="hidden" name="do" value="save_tg_prefs">

    <h3 class="h3">По ролям</h3>
    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <th>Уведомление</th>
            <?php foreach ($roles as $rk=>$rn): ?><th><?= h($rn) ?></th><?php endforeach; ?>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($keys as $k=>$kn): ?>
            <tr>
              <td><b><?= h($kn) ?></b></td>
              <?php foreach ($roles as $rk=>$rn):
                $row = $role_map[$k][$rk] ?? ['is_enabled'=>0,'send_time'=>null];
              ?>
                <td style="white-space:nowrap;">
                  <label style="display:flex; gap:8px; align-items:center;">
                    <input type="checkbox" name="en_<?= h($k) ?>_<?= h($rk) ?>" value="1" <?= ((int)$row['is_enabled']===1?'checked':'') ?>>
                    <span class="muted">вкл</span>
                  </label>
                  <?php if ($k==='daily_products'): ?>
                    <input type="time" name="tm_<?= h($k) ?>_<?= h($rk) ?>" value="<?= h($row['send_time'] ?? '') ?>" style="margin-top:6px; width:110px;">
                  <?php endif; ?>
                </td>
              <?php endforeach; ?>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <div class="hr"></div>

    <h3 class="h3">По пользователям</h3>
    <div class="muted">Показываем только активных пользователей с Telegram ID.</div>

    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <th>Пользователь</th>
            <th>Роль</th>
            <th>Низкий остаток</th>
            <th>Ежедневный отчёт</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($users as $us):
            $uid = (int)$us['id'];
            $u_low = $user_map['low_material'][$uid] ?? null;
            $u_day = $user_map['daily_products'][$uid] ?? null;
          ?>
            <tr>
              <td><b><?= h($us['full_name']) ?></b></td>
              <td class="muted"><?= h($roles[$us['role']] ?? $us['role']) ?></td>
              <td>
                <input type="checkbox" name="u_en_low_material_<?= $uid ?>" value="1" <?= ($u_low && (int)$u_low['is_enabled']===1?'checked':'') ?>>
              </td>
              <td>
                <input type="checkbox" name="u_en_daily_products_<?= $uid ?>" value="1" <?= ($u_day && (int)$u_day['is_enabled']===1?'checked':'') ?>>
                <input type="time" name="u_tm_daily_products_<?= $uid ?>" value="<?= h($u_day['send_time'] ?? '') ?>" style="margin-left:10px; width:110px;">
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (count($users)===0): ?>
            <tr><td colspan="4" class="muted">Нет пользователей с Telegram ID</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="actions" style="margin-top:12px;">
      <button class="btn" type="submit">Сохранить</button>
    </div>
  </form>
</section>
