<?php $tab='telegram'; require __DIR__ . '/_tabs.php'; ?>

<div class="card">
  <div class="card-head">
    <h2 class="h2">Настройки → Уведомления (Telegram)</h2>
    <div class="muted">токен бота + включение уведомлений по ролям</div>
  </div>


<div class="actions" style="margin:10px 0 14px;">
  <a class="btn" href="index.php?m=settings&a=telegram&send_daily=1" onclick="return confirm('Отправить ежедневный отчёт в Telegram прямо сейчас?');">Отправить ежедневный отчёт сейчас (тест)</a>
  <span class="muted" style="margin-left:10px;">Для автоматической отправки нужен cron: <code>*/5 * * * * /usr/local/bin/php /usr/local/www/apache24/data/ascrm/scripts/telegram_cron.php</code></span>
</div>

  <?php if (!empty($msg)): ?><div class="alert" style="border-color: rgba(25,195,125,.35);"><?= h($msg) ?></div><?php endif; ?>

  <form method="post">
    <div class="field">
      <label>Telegram Bot Token (доступ только admin/director)</label>
      <input name="token" value="<?= h($token) ?>" placeholder="123456:ABC-DEF...">
      <div class="small">Токен хранится в БД. Для отправки сообщений у пользователей должен быть заполнен Telegram ID.</div>
    </div>

    <div class="hr"></div>

    <?php foreach ($notifs as $n): ?>
      <section class="card soft">
        <div class="card-head">
          <h2 class="h2"><?= h($n['title']) ?></h2>
          <div class="muted"><?= h($n['code']) ?></div>
        </div>

        <div class="table-wrap">
          <table>
            <thead>
              <tr>
                <th>Роль</th>
                <th>Включено</th>
                <th>Время (для ежедневного отчёта)</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach (($by_code[$n['code']] ?? []) as $r): 
                $key = $r['notification_code'].'__'.$r['role'];
              ?>
              <tr>
                <td><b><?= h($r['role']) ?></b></td>
                <td>
                  <label style="display:flex; gap:8px; align-items:center;">
                    <input type="checkbox" name="en[<?= h($key) ?>]" value="1" <?= ((int)$r['is_enabled']===1?'checked':'') ?>>
                    <span class="muted">да</span>
                  </label>
                </td>
                <td>
                  <?php if ($n['code']==='daily_products'): ?>
                    <input name="time[<?= h($key) ?>]" value="<?= h(substr((string)$r['send_time'],0,5)) ?>" placeholder="19:00" style="max-width:120px;">
                  <?php else: ?>
                    <span class="muted">—</span>
                    <input type="hidden" name="time[<?= h($key) ?>]" value="">
                  <?php endif; ?>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>

        <?php if ($n['code']==='low_stock'): ?>
          <div class="small" style="margin-top:10px;">
            Уведомление срабатывает автоматически при списании/перемещении, когда остаток по локации падает ниже минимума и материал не отмечен как “Заказано”.
          </div>
        <?php endif; ?>

        <?php if ($n['code']==='daily_products'): ?>
          <div class="small" style="margin-top:10px;">
            Отчёт берётся из “Комплектация изделия” (сборки за день). Для отправки нужен cron (см. scripts/telegram_cron.php).
          </div>
        <?php endif; ?>
      </section>
    <?php endforeach; ?>

    <div class="actions" style="margin-top:14px;">
      <button class="btn primary" type="submit">Сохранить</button>
    </div>
  </form>
</div>
