<?php $tab='products'; require __DIR__ . '/_tabs.php'; ?>

<div class="card">
  <div class="card-head">
    <h2 class="h2">Настройки → Готовая продукция</h2>
    <div class="muted">изделия и состав (детали + количество на 1 изделие)</div>
  </div>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="settings">
    <input type="hidden" name="a" value="products">
    <input name="q" placeholder="поиск: название изделия" value="<?= h($q) ?>">
    <button class="btn" type="submit">Показать</button>
    <a class="btn primary" href="index.php?m=settings&a=product_edit">+ Создать изделие</a>
  </form>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Изделие</th>
          <th>Статус</th>
          <th>Деталей в составе</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
        <tr>
          <td><b><?= h($r['name']) ?></b></td>
          <td><?= ((int)$r['is_active']===1) ? '<span class="pill" style="color:var(--ok);">активно</span>' : '<span class="pill" style="color:var(--danger);">выкл</span>' ?></td>
          <td class="muted"><?= (int)$r['parts_cnt'] ?></td>
          <td style="white-space:nowrap;">
            <a class="btn" href="index.php?m=settings&a=product_edit&id=<?= (int)$r['id'] ?>">Редактировать</a>
            <a class="btn danger" href="index.php?m=settings&a=product_delete&id=<?= (int)$r['id'] ?>" onclick="return confirm('Удалить изделие?')">Удалить</a>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
          <tr><td colspan="4" class="muted">Пока нет изделий</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="small" style="margin-top:10px;">
    Это справочник. Следующим шагом сделаем “Склад → Готовая продукция” (отгрузка + история) и “Производство → Комплектация изделия”.
  </div>
</div>
