<?php $tab='ops'; require __DIR__ . '/_tabs.php'; ?>
<script src="assets/ops.js?v=1" defer></script>

<div class="card">
  <div class="card-head">
    <h2 class="h2">Операция</h2>
    <div class="muted"><?= $id>0 ? 'редактирование' : 'создание' ?></div>
  </div>

  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="post">
    <div class="form-grid">
      <div class="field">
        <label>Локация*</label>
        <select name="location_id" required onchange="this.form.submit()">
          <option value="0">— выберите —</option>
          <?php foreach ($locations as $l): ?>
            <option value="<?= (int)$l['id'] ?>" <?= ((int)$selected_location_id===(int)$l['id']?'selected':'') ?>>
              <?= h($l['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="field">
        <label>Цех*</label>
        <select name="workshop_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($workshops as $w): ?>
            <option value="<?= (int)$w['id'] ?>" <?= ((int)($item['workshop_id'] ?? 0)===(int)$w['id']?'selected':'') ?>>
              <?= h($w['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Наименование операции*</label>
        <input name="name" required value="<?= h($item['name'] ?? '') ?>">
      </div>
      <div class="field">
        <label>План на день (1 сотрудник)</label>
        <input name="daily_plan_per_employee" value="<?= h($item['daily_plan_per_employee'] ?? '0') ?>" placeholder="например: 100">
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Цена за 1 операцию*</label>
        <input name="price" required value="<?= h($item['price'] ?? '0') ?>" placeholder="например: 10">
      </div>
      <div class="field">
        <label>Коэф. цена с браком (%)</label>
        <input name="defect_coef_pct" value="<?= h($item['defect_coef_pct'] ?? '0') ?>" placeholder="например: 50 (будет 50% от цены)">
      </div>
    </div>

    <div class="field" style="margin-top:12px;">
      <label><input type="checkbox" name="is_active" value="1" <?= ((int)($item['is_active'] ?? 1)===1?'checked':'') ?>> Активна</label>
    </div>

    <div class="field" style="margin-top:12px;">
      <label>Описание</label>
      <textarea name="description"><?= h($item['description'] ?? '') ?></textarea>
    </div>

    <div class="hr"></div>

    <div class="card" style="padding:12px;">
      <div class="card-head">
        <h2 class="h2">Материалы / расходники на 1 операцию</h2>
        <div class="muted">будут списываться при вводе выработки</div>
      </div>

      <div class="actions">
        <button class="btn" type="button" onclick="opiAddRow()">+ Добавить строку</button>
      </div>

      <div class="table-wrap">
        <table>
          <thead>
            <tr>
              <th>Тип</th>
              <th>Позиция</th>
              <th>Кол-во на 1 операцию</th>
              <th></th>
            </tr>
          </thead>
          <tbody id="opi-body">
            <?php foreach ($opi as $r): ?>
            <tr>
              <td>
                <select name="row_type[]">
                  <option value="material" <?= ($r['item_type']==='material'?'selected':'') ?>>Материал</option>
                  <option value="consumable" <?= ($r['item_type']==='consumable'?'selected':'') ?>>Расходник</option>
                </select>
              </td>
              <td>
                <select name="row_item[]">
                  <?php if ($r['item_type']==='material'): ?>
                    <?php foreach ($materials as $m): ?>
                      <option value="<?= (int)$m['id'] ?>" <?= ((int)$r['item_id']===(int)$m['id']?'selected':'') ?>><?= h($m['name']) ?></option>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <?php foreach ($consumables as $c): ?>
                      <option value="<?= (int)$c['id'] ?>" <?= ((int)$r['item_id']===(int)$c['id']?'selected':'') ?>><?= h($c['name']) ?></option>
                    <?php endforeach; ?>
                  <?php endif; ?>
                </select>
              </td>
              <td><input name="row_qty[]" value="<?= h($r['qty_per_op']) ?>" style="max-width:180px;"></td>
              <td><button class="btn danger" type="button" onclick="opiDelRow(this)">Удалить</button></td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <template id="opi-template">
        <tr>
          <td>
            <select name="row_type[]">
              <option value="material">Материал</option>
              <option value="consumable">Расходник</option>
            </select>
          </td>
          <td>
            <select name="row_item[]">
              <?php foreach ($materials as $m): ?>
                <option value="<?= (int)$m['id'] ?>"><?= h($m['name']) ?></option>
              <?php endforeach; ?>
            </select>
            <div class="small">Если нужен расходник — выберите тип “Расходник”, потом сохраните и отредактируйте (MVP упрощение).</div>
          </td>
          <td><input name="row_qty[]" value="1" style="max-width:180px;"></td>
          <td><button class="btn danger" type="button" onclick="opiDelRow(this)">Удалить</button></td>
        </tr>
      </template>
    </div>

    <div class="actions">
      <button class="btn primary" type="submit">Сохранить</button>
      <a class="btn" href="index.php?m=settings&a=operations">Назад</a>
    </div>
  </form>
</div>
