<?php $tab='matcats'; require __DIR__ . '/_tabs.php'; ?>
<div class="card">
  <div class="card-head">
    <h2 class="h2">Настройки → Категории материалов</h2>
    <div class="muted"><?= count($cats) ?></div>
  </div>

  <div class="actions">
    <a class="btn primary" href="index.php?m=settings&a=material_category_edit">+ Создать категорию</a>
  </div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Наименование</th>
          <th>Описание</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($cats as $c): ?>
        <tr>
          <td><?= h($c['name']) ?></td>
          <td class="muted"><?= h($c['description']) ?></td>
          <td style="white-space:nowrap;">
            <a class="btn" href="index.php?m=settings&a=material_category_edit&id=<?= (int)$c['id'] ?>">Редактировать</a>
            <a class="btn danger" href="index.php?m=settings&a=material_category_delete&id=<?= (int)$c['id'] ?>" onclick="return confirm('Удалить категорию?')">Удалить</a>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($cats)===0): ?>
        <tr><td colspan="3" class="muted">Категорий пока нет</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="small" style="margin-top:10px;">
    Эти категории будут доступны при создании материалов, инструмента и расходных материалов.
  </div>
</div>
