<?php $tab='productivity'; require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Производство</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Учет производительности</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Учет производительности</h2>
    <div class="muted">ввод выработки + автоматическое списание материалов по операции (со склада цеха)</div>
  </div>

  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="production">
    <input type="hidden" name="a" value="productivity">

    <input type="date" name="date" value="<?= h($date) ?>">

    <select name="location_id" onchange="this.form.submit()">
      <option value="0">Локация: выберите</option>
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$location_id===(int)$l['location_id']?'selected':'') ?>>
          <?= h($l['location_name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <select name="workshop_id" onchange="this.form.submit()">
      <option value="0">Цех: выберите</option>
      <?php foreach ($workshops as $w): ?>
        <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>>
          <?= h($w['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <button class="btn" type="submit">Показать</button>
  </form>

  <div class="hr"></div>

  <h3 class="h2" style="margin-bottom:8px;">Ввод выработки</h3>

  <form method="post">
    <div class="form-grid">
      <div class="field">
        <label>Дата</label>
        <input type="date" name="work_date" value="<?= h($date) ?>">
      </div>
      <div class="field">
        <label>Количество (раз выполнения операции)*</label>
        <input name="qty" required placeholder="например: 150">
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Локация*</label>
        <select name="location_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($locations as $l): ?>
            <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$location_id===(int)$l['location_id']?'selected':'') ?>>
              <?= h($l['location_name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="field">
        <label>Цех*</label>
        <select name="workshop_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($workshops as $w): ?>
            <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>>
              <?= h($w['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
        <div class="small">Списания будут идти со склада выбранного цеха.</div>
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Сотрудник*</label>
        <select name="employee_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($employees as $e): ?>
            <option value="<?= (int)$e['id'] ?>"><?= h($e['full_name']) ?></option>
          <?php endforeach; ?>
        </select>
        <div class="small">Список фильтруется по локации и цеху.</div>
      </div>
      <div class="field">
        <label>Операция*</label>
        <select name="operation_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($operations as $o): ?>
            <option value="<?= (int)$o['id'] ?>"><?= h($o['name']) ?> (<?= h($o['price']) ?>)</option>
          <?php endforeach; ?>
        </select>
        <div class="small">Материалы/расходники для списания задаются в Настройки → Операции.</div>
      </div>
    </div>

    <div class="actions">
      <button class="btn primary" type="submit">Сохранить выработку</button>
      <a class="btn" href="index.php?m=warehouse&a=index">Проверить склад</a>
    </div>
  </form>
</section>

<section class="card" style="margin-top:14px;">
  <div class="card-head">
    <h2 class="h2">Журнал за день</h2>
    <div class="muted"><?= h($date) ?></div>
  </div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Сотрудник</th>
          <th>Операция</th>
          <th>Кол-во</th>
          <th>Цена</th>
          <th>Сумма</th>
          <th>Кто внёс</th>
          <th>Создано</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($logs as $l): ?>
        <tr>
          <td><?= (int)$l['id'] ?></td>
          <td><b><?= h($l['emp_name']) ?></b></td>
          <td><?= h($l['op_name']) ?></td>
          <td><?= h($l['qty']) ?></td>
          <td class="muted"><?= h($l['price_at_time']) ?></td>
          <td><b><?= h($l['amount']) ?></b></td>
          <td class="muted"><?= h($l['user_name']) ?></td>
          <td class="muted"><?= h($l['created_at']) ?></td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($logs)===0): ?>
        <tr><td colspan="8" class="muted">Пока нет записей</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>
