<?php $tab='finished_stock'; require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Производство</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Склад готовых деталей</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Склад готовых деталей</h2>
    <div class="muted">Бригадир видит доступные детали и может получить на цех или сотрудника</div>
  </div>

  <?php if ($ok==='1'): ?>
    <div class="alert" style="border-color: rgba(25,195,125,.35);">Выдача выполнена.</div>
  <?php endif; ?>

  <?php if ($err==='qty'): ?><div class="alert">Количество должно быть больше 0</div><?php endif; ?>
  <?php if ($err==='bal'): ?><div class="alert">Недостаточно деталей на складе</div><?php endif; ?>
  <?php if ($err==='to'): ?><div class="alert">Выберите кому выдаём (цех или сотрудник)</div><?php endif; ?>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="production">
    <input type="hidden" name="a" value="finished_stock">

    <select name="location_id" onchange="this.form.submit()">
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['id'] ?>" <?= ((int)$location_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
      <?php endforeach; ?>
    </select>

    <select name="workshop_id" onchange="this.form.submit()">
      <?php foreach ($workshops as $w): ?>
        <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
      <?php endforeach; ?>
    </select>

    <span class="pill">Цех-источник</span>
  </form>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Деталь</th>
          <th>Доступно</th>
          <th>Получить</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
        <tr>
          <td><b><?= h($r['name']) ?></b></td>
          <td><?= h($r['bal']) ?></td>
          <td>
            <form method="post" action="index.php?m=production&a=finished_issue" style="display:flex; gap:10px; flex-wrap:wrap; align-items:center;">
              <input type="hidden" name="location_id" value="<?= (int)$location_id ?>">
              <input type="hidden" name="from_workshop_id" value="<?= (int)$workshop_id ?>">
              <input type="hidden" name="part_id" value="<?= (int)$r['id'] ?>">

              <input name="qty" placeholder="кол-во" style="max-width:120px;">
              <select name="to_type" onchange="this.closest('form').querySelectorAll('.to-workshop,.to-employee').forEach(el=>el.style.display='none'); this.closest('form').querySelector(this.value==='employee'?'.to-employee':'.to-workshop').style.display='block';">
                <option value="workshop">на цех</option>
                <option value="employee">на сотрудника</option>
              </select>

              <select class="to-workshop" name="to_id">
                <option value="0">— цех —</option>
                <?php foreach ($workshops as $w): ?>
                  <option value="<?= (int)$w['id'] ?>"><?= h($w['name']) ?></option>
                <?php endforeach; ?>
              </select>

              <select class="to-employee" name="to_id" style="display:none;">
                <option value="0">— сотрудник —</option>
                <?php foreach ($employees as $e): ?>
                  <option value="<?= (int)$e['id'] ?>"><?= h($e['full_name']) ?></option>
                <?php endforeach; ?>
              </select>

              <input name="comment" placeholder="комментарий" style="max-width:220px;">
              <button class="btn primary" type="submit">Получить</button>
            </form>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
          <tr><td colspan="3" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="small" style="margin-top:10px;">
    Склад готовых деталей — виртуальный. Количество попадает сюда после “Готовые детали”.
  </div>
</section>
