<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Детали</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Детали</h2>
    <div class="muted">спецификация материалов + маршрут операций</div>
  </div>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="parts">
    <input type="hidden" name="a" value="index">

    <select name="location_id" onchange="this.form.submit()">
      <option value="0">Локация: все</option>
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$location_id===(int)$l['location_id']?'selected':'') ?>>
          <?= h($l['location_name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <select name="workshop_id">
      <option value="0">Цех: все</option>
      <?php foreach ($workshops as $w): ?>
        <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>>
          <?= h($w['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <input name="q" placeholder="поиск: название или код" value="<?= h($q) ?>">
    <button class="btn" type="submit">Показать</button>

    <?php if (in_array($u['role'], ['admin','director','prod_head'], true)): ?>
      <a class="btn primary" href="index.php?m=parts&a=edit">+ Создать</a>
    <?php endif; ?>
  </form>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Деталь</th>
          <th>Код</th>
          <th>Локация</th>
          <th>Цех</th>
          <th>План/день</th>
          <th>Кол-во на изделие (по умолч.)</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
        <tr>
          <td><b><?= h($r['name']) ?></b></td>
          <td class="muted"><?= h($r['code']) ?></td>
          <td class="muted"><?= h($r['location_name']) ?></td>
          <td class="muted"><?= h($r['workshop_name']) ?></td>
          <td><?= h($r['daily_plan']) ?></td>
          <td><?= h($r['qty_per_product_default']) ?></td>
          <td style="white-space:nowrap;">
            <?php if (in_array($u['role'], ['admin','director','prod_head'], true)): ?>
              <a class="btn" href="index.php?m=parts&a=edit&id=<?= (int)$r['id'] ?>">Редактировать</a>
            <?php endif; ?>
            <?php if (in_array($u['role'], ['admin','director'], true)): ?>
              <a class="btn danger" href="index.php?m=parts&a=delete&id=<?= (int)$r['id'] ?>" onclick="return confirm('Удалить деталь?')">Удалить</a>
            <?php endif; ?>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
        <tr><td colspan="7" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="small" style="margin-top:10px;">
    Примечание: “Кол-во на изделие (по умолч.)” — временно. В модуле “Готовая продукция” будет задаваться состав изделия и количества по каждому изделию.
  </div>
</section>
