<?php
// views/materials/index.php
require_once __DIR__ . '/../../app/format.php';

// $type: material|tool|consumable
$title = 'Материалы';
if ($type === 'tool') $title = 'Инструмент';
if ($type === 'consumable') $title = 'Расходные материалы';
?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb"><?= h($title) ?></span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2"><?= h($title) ?></h2>
    <div class="actions">
      <a class="btn" href="index.php?m=materials&a=edit&type=<?= h($type) ?>">+ Добавить</a>
    </div>
  </div>

  <div class="tabs" style="margin-top:6px;">
    <a class="tab <?= ($type==='material'?'active':'') ?>" href="index.php?m=materials&a=index&type=material">Материалы</a>
    <a class="tab <?= ($type==='tool'?'active':'') ?>" href="index.php?m=materials&a=index&type=tool">Инструмент</a>
    <a class="tab <?= ($type==='consumable'?'active':'') ?>" href="index.php?m=materials&a=index&type=consumable">Расходники</a>
  </div>

  <div class="hr"></div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Наименование</th>
          <th>Категория</th>
          <th>Ед. изм.</th>
          <th style="text-align:right;">Минимум</th>
          <th style="text-align:right;">Цена</th>
          <th style="width:110px;"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><a href="index.php?m=materials&a=edit&type=<?= h($type) ?>&id=<?= (int)$r['id'] ?>"><b><?= h($r['name'] ?? '') ?></b></a>
              <?php if (!empty($r['code'])): ?><div class="muted"><?= h($r['code']) ?></div><?php endif; ?>
            </td>
            <td class="muted"><?= h($r['category_name'] ?? '—') ?></td>
            <td class="muted"><?= h($r['unit'] ?? '') ?></td>
            <td style="text-align:right;"><?= h(fmt_qty($r['minimum_qty'] ?? '')) ?></td>
            <td style="text-align:right;"><?= h(fmt_qty($r['price'] ?? '')) ?></td>
            <td style="text-align:right;">
              <a class="btn btn-sm" href="index.php?m=materials&a=edit&type=<?= h($type) ?>&id=<?= (int)$r['id'] ?>">Открыть</a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
          <tr><td colspan="6" class="muted">Пока нет записей</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>
