<?php
require_once __DIR__ . '/../../app/format.php';
require_once __DIR__ . '/../../modules/materials/flash.php';

$ok = isset($_GET['ok']);
$err = materials_flash_get('mat_err');

$price_col = $price_col ?? null; // current_price или price
$has_minimum = (bool)($has_minimum ?? false);
?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <a class="crumb" href="index.php?m=materials&a=index&type=<?= h($type) ?>">Материалы</a>
  <span class="crumb-sep">/</span>
  <span class="crumb"><?= $id>0 ? 'Редактирование' : 'Создание' ?></span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2"><?= $id>0 ? 'Карточка материала' : 'Новый материал' ?></h2>
    <div class="muted">Без привязки к локации и цеху</div>
  </div>

  <?php if ($ok): ?><div class="notice ok">Сохранено</div><?php endif; ?>
  <?php if ($err): ?><div class="notice err"><?= h($err) ?></div><?php endif; ?>

  <form method="post">
    <input type="hidden" name="do" value="save">
    <input type="hidden" name="id" value="<?= (int)$id ?>">
    <input type="hidden" name="type" value="<?= h($type) ?>">

    <div class="grid-2">
      <div class="field">
        <label>Категория</label>
        <select name="category_id">
          <option value="0">—</option>
          <?php foreach ($cats as $c): ?>
            <option value="<?= (int)$c['id'] ?>" <?= ((int)($row['category_id'] ?? 0)===(int)$c['id']?'selected':'') ?>><?= h($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="field">
        <label>Код (необязательно)</label>
        <input type="text" name="code" value="<?= h($row['code'] ?? '') ?>">
      </div>

      <div class="field">
        <label>Название</label>
        <input type="text" name="name" value="<?= h($row['name'] ?? '') ?>" required>
      </div>

      <div class="field">
        <label>Ед. измерения</label>
        <input type="text" name="unit" value="<?= h($row['unit'] ?? '') ?>" required>
      </div>

      <?php if ($price_col): ?>
      <div class="field">
        <label>Текущая цена (необязательно)</label>
        <input type="text" name="price" value="<?= h(fmt_qty($row[$price_col] ?? '')) ?>" placeholder="например 12.5">
      </div>
      <?php endif; ?>

      <?php if ($has_minimum): ?>
      <div class="field">
        <label>Складской минимум (Telegram)</label>
        <input type="text" name="minimum_qty" value="<?= h(fmt_qty($row['minimum_qty'] ?? '')) ?>" placeholder="например 10">
      </div>
      <?php endif; ?>

      <div class="field" style="grid-column:1 / -1;">
        <label style="display:flex; gap:10px; align-items:center;">
          <input type="checkbox" name="is_active" value="1" <?= ((int)($row['is_active'] ?? 1)===1?'checked':'') ?>>
          <span>Активен</span>
        </label>
      </div>
    </div>

    <div class="field" style="margin-top:10px;">
      <label>Описание</label>
      <textarea name="description" rows="4"><?= h($row['description'] ?? '') ?></textarea>
    </div>

    <div class="actions" style="margin-top:12px;">
      <button class="btn" type="submit">Сохранить</button>
      <a class="btn" href="index.php?m=materials&a=index&type=<?= h($type) ?>">Назад</a>
      <?php if ($id>0): ?>
        <a class="btn btn-danger" href="index.php?m=materials&a=edit&type=<?= h($type) ?>&id=<?= (int)$id ?>&del=1" onclick="return confirm('Удалить?')">Удалить</a>
      <?php endif; ?>
    </div>
  </form>
</section>
