<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/warehouse.php';
require_once dirname(__DIR__, 2) . '/app/product_warehouse.php';

function warehouse_index() {
    $u = require_role(['admin','director','storekeeper','prod_head','brigadier']);
    wh_ensure_places_exist();

    $type = $_GET['type'] ?? 'material';
    if (!in_array($type, ['material','tool','consumable','product'], true)) $type='material';

    $location_id = (int)($_GET['location_id'] ?? 0);
    $locations = wh_get_user_locations_for_warehouse($u);

    if ($location_id === 0 && count($locations)===1) $location_id = (int)$locations[0]['location_id'];
    if ($location_id > 0) wh_require_location_access_by_user($u, $location_id);

    
// Готовая продукция — отдельный экран
if ($type === 'product') {
    return warehouse_products($u, $location_id, $locations);
}

// Items list
    if ($type === 'material') { $tbl='materials'; $title='Склад → Материал'; }
    if ($type === 'tool') { $tbl='tools'; $title='Склад → Инструмент'; }
    if ($type === 'consumable') { $tbl='consumables'; $title='Склад → Расходные материалы'; }

    $q = trim($_GET['q'] ?? '');
    $where = "i.is_active=1";
    if ($q !== '') {
        $qesc = db_escape($q);
        $where .= " AND (i.name LIKE '%$qesc%' OR i.code LIKE '%$qesc%')";
    }

    // Баланс по выбранной локации: суммируем все входы/выходы по местам этой локации
    $balance_sql = "0 AS qty";
    if ($location_id > 0) {
        $balance_sql = "
          (
            SELECT COALESCE(SUM(delta),0) FROM (
              SELECT sm.qty AS delta
                FROM stock_moves sm
                JOIN storage_places p ON p.id=sm.to_place_id
               WHERE sm.item_type='$type' AND sm.item_id=i.id AND sm.is_reversed=0 AND p.location_id=$location_id
              UNION ALL
              SELECT -sm.qty AS delta
                FROM stock_moves sm
                JOIN storage_places p ON p.id=sm.from_place_id
               WHERE sm.item_type='$type' AND sm.item_id=i.id AND sm.is_reversed=0 AND p.location_id=$location_id
            ) x
          ) AS qty
        ";
    }

    $items = db_fetch_all(db_query("
      SELECT i.id, i.code, i.name, $balance_sql
      FROM $tbl i
      WHERE $where
      ORDER BY i.name
    "));

    render('warehouse/index', [
        'u'=>$u,
        'type'=>$type,
        'title'=>$title,
        'locations'=>$locations,
        'location_id'=>$location_id,
        'q'=>$q,
        'items'=>$items
    ]);
}

function warehouse_details() {
    $u = require_role(['admin','director','storekeeper','prod_head','brigadier']);
    wh_ensure_places_exist();

    $type = $_GET['type'] ?? 'material';
    if (!in_array($type, ['material','tool','consumable','product'], true)) $type='material';

    $id = (int)($_GET['id'] ?? 0);
    $location_id = (int)($_GET['location_id'] ?? 0);
    if ($id<=0 || $location_id<=0) { header("Location: index.php?m=warehouse&a=index&type=".urlencode($type)); exit; }

    wh_require_location_access_by_user($u, $location_id);

    if ($type === 'material') { $tbl='materials'; }
    if ($type === 'tool') { $tbl='tools'; }
    if ($type === 'consumable') { $tbl='consumables'; }

    $item = db_fetch_one(db_query("SELECT * FROM $tbl WHERE id=$id LIMIT 1"));
    if (!$item) { http_response_code(404); echo "Не найдено"; exit; }

    $balances = wh_get_balances_by_place($type, $id, $location_id);
    $places = wh_list_places_for_location($location_id);

    // Последние движения по этому товару в этой локации
    $moves = db_fetch_all(db_query("
      SELECT sm.*, uf.full_name AS user_name,
             pf.name AS from_name, pt.name AS to_name
      FROM stock_moves sm
      LEFT JOIN users uf ON uf.id=sm.created_by
      LEFT JOIN storage_places pf ON pf.id=sm.from_place_id
      LEFT JOIN storage_places pt ON pt.id=sm.to_place_id
      WHERE sm.item_type='".db_escape($type)."' AND sm.item_id=$id
        AND sm.is_reversed=0
        AND (
             (pf.location_id=$location_id) OR (pt.location_id=$location_id)
        )
      ORDER BY sm.id DESC
      LIMIT 50
    "));

    render('warehouse/details', [
        'u'=>$u,
        'type'=>$type,
        'location_id'=>$location_id,
        'item'=>$item,
        'balances'=>$balances,
        'places'=>$places,
        'moves'=>$moves
    ]);
}

function warehouse_receipt() {
    $u = require_role(['admin','director','storekeeper','prod_head']);
    wh_ensure_places_exist();

    $type = $_GET['type'] ?? 'material';
    if (!in_array($type, ['material','tool','consumable'], true)) $type='material';

    $locations = wh_get_user_locations_for_warehouse($u);
    $location_id = (int)($_GET['location_id'] ?? 0);
    if ($location_id === 0 && count($locations)===1) $location_id=(int)$locations[0]['location_id'];
    if ($location_id > 0) wh_require_location_access_by_user($u, $location_id);

    if ($type === 'material') { $tbl='materials'; $title='Приход материала'; }
    if ($type === 'tool') { $tbl='tools'; $title='Приход инструмента'; }
    if ($type === 'consumable') { $tbl='consumables'; $title='Приход расходников'; }

    $items = db_fetch_all(db_query("SELECT id, name FROM $tbl WHERE is_active=1 ORDER BY name"));

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $location_id = (int)($_POST['location_id'] ?? 0);
        $item_id = (int)($_POST['item_id'] ?? 0);
        $qty = str_replace(',', '.', trim($_POST['qty'] ?? '0'));
        $unit_price = str_replace(',', '.', trim($_POST['unit_price'] ?? ''));
        $supplier = trim($_POST['supplier'] ?? '');
        $invoice_no = trim($_POST['invoice_no'] ?? '');
        $comment = trim($_POST['comment'] ?? '');

        if ($location_id<=0 || $item_id<=0) $msg='Выберите локацию и позицию';
        else if (!is_numeric($qty) || (float)$qty<=0) $msg='Количество должно быть больше 0';
        else {
            wh_require_location_access_by_user($u, $location_id);

            // документ прихода
            $sup_esc = db_escape($supplier);
            $inv_esc = db_escape($invoice_no);
            $com_esc = db_escape($comment);
            db_query("INSERT INTO purchase_receipts(location_id,supplier,invoice_no,comment,created_at,created_by)
                      VALUES ($location_id,'$sup_esc','$inv_esc','$com_esc',NOW(),".(int)$u['id'].")");
            $rid = (int)db_last_id();

            // приход всегда на склад локации
            $to_place = wh_get_place_id($location_id, 'warehouse', 0);
            wh_move_create([
                'item_type'=>$type,
                'item_id'=>$item_id,
                'move_type'=>'receipt',
                'from_place_id'=>null,
                'to_place_id'=>$to_place,
                'qty'=>(float)$qty,
                'unit_price'=>$unit_price,
                'receipt_id'=>$rid,
                'reason'=>'Приход',
                'comment'=>$comment
            ], (int)$u['id']);

            header("Location: index.php?m=warehouse&a=details&type=".urlencode($type)."&id=$item_id&location_id=$location_id");
            exit;
        }
    }

    render('warehouse/receipt', [
        'u'=>$u,'type'=>$type,'title'=>$title,'locations'=>$locations,'location_id'=>$location_id,'items'=>$items,'msg'=>$msg
    ]);
}

function warehouse_transfer() {
    $u = require_role(['admin','director','storekeeper','prod_head']);
    wh_ensure_places_exist();

    $type = $_GET['type'] ?? 'material';
    if (!in_array($type, ['material','tool','consumable'], true)) $type='material';

    $locations = wh_get_user_locations_for_warehouse($u);
    $location_id = (int)($_GET['location_id'] ?? 0);
    if ($location_id === 0 && count($locations)===1) $location_id=(int)$locations[0]['location_id'];
    if ($location_id > 0) wh_require_location_access_by_user($u, $location_id);

    if ($type === 'material') { $tbl='materials'; $title='Перемещение материала'; }
    if ($type === 'tool') { $tbl='tools'; $title='Перемещение инструмента'; }
    if ($type === 'consumable') { $tbl='consumables'; $title='Перемещение расходников'; }

    $items = db_fetch_all(db_query("SELECT id, name FROM $tbl WHERE is_active=1 ORDER BY name"));
    $places = ($location_id>0) ? wh_list_places_for_location($location_id) : [];

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $location_id = (int)($_POST['location_id'] ?? 0);
        $item_id = (int)($_POST['item_id'] ?? 0);
        $from_place = (int)($_POST['from_place_id'] ?? 0);
        $to_place = (int)($_POST['to_place_id'] ?? 0);
        $qty = str_replace(',', '.', trim($_POST['qty'] ?? '0'));
        $comment = trim($_POST['comment'] ?? '');
        $reason = trim($_POST['reason'] ?? 'Перемещение');

        if ($location_id<=0 || $item_id<=0) $msg='Выберите локацию и позицию';
        else if ($from_place<=0 || $to_place<=0 || $from_place===$to_place) $msg='Выберите разные места хранения';
        else if (!is_numeric($qty) || (float)$qty<=0) $msg='Количество должно быть больше 0';
        else {
            wh_require_location_access_by_user($u, $location_id);

            // проверка остатка
            $bal = wh_get_balance($type, $item_id, $from_place);
            if ($bal < (float)$qty - 0.0001) {
                $msg = 'Недостаточно остатка в источнике. Доступно: ' . $bal;
            } else {
                wh_move_create([
                    'item_type'=>$type,'item_id'=>$item_id,'move_type'=>'transfer',
                    'from_place_id'=>$from_place,'to_place_id'=>$to_place,
                    'qty'=>(float)$qty,'reason'=>$reason,'comment'=>$comment
                ], (int)$u['id']);

                header("Location: index.php?m=warehouse&a=details&type=".urlencode($type)."&id=$item_id&location_id=$location_id");
                exit;
            }
        }
        // update places if location changed
        $places = ($location_id>0) ? wh_list_places_for_location($location_id) : [];
    }

    render('warehouse/transfer', [
        'u'=>$u,'type'=>$type,'title'=>$title,'locations'=>$locations,'location_id'=>$location_id,'items'=>$items,'places'=>$places,'msg'=>$msg
    ]);
}

function warehouse_adjust() {
    $u = require_role(['admin','director','storekeeper','prod_head']);
    wh_ensure_places_exist();

    $type = $_GET['type'] ?? 'material';
    if (!in_array($type, ['material','tool','consumable'], true)) $type='material';

    $locations = wh_get_user_locations_for_warehouse($u);
    $location_id = (int)($_GET['location_id'] ?? 0);
    if ($location_id === 0 && count($locations)===1) $location_id=(int)$locations[0]['location_id'];
    if ($location_id > 0) wh_require_location_access_by_user($u, $location_id);

    if ($type === 'material') { $tbl='materials'; $title='Корректировка остатка (материал)'; }
    if ($type === 'tool') { $tbl='tools'; $title='Корректировка остатка (инструмент)'; }
    if ($type === 'consumable') { $tbl='consumables'; $title='Корректировка остатка (расходники)'; }

    $items = db_fetch_all(db_query("SELECT id, name FROM $tbl WHERE is_active=1 ORDER BY name"));
    $places = ($location_id>0) ? wh_list_places_for_location($location_id) : [];

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $location_id = (int)($_POST['location_id'] ?? 0);
        $item_id = (int)($_POST['item_id'] ?? 0);
        $place_id = (int)($_POST['place_id'] ?? 0);
        $delta = str_replace(',', '.', trim($_POST['delta_qty'] ?? '0'));
        $reason = trim($_POST['reason'] ?? '');
        $comment = trim($_POST['comment'] ?? '');

        if ($location_id<=0 || $item_id<=0 || $place_id<=0) $msg='Заполните локацию, позицию и место хранения';
        else if (!is_numeric($delta) || (float)$delta==0.0) $msg='Дельта должна быть не нулевой (например: 5 или -2)';
        else if ($reason === '' || $comment === '') $msg='Причина и комментарий обязательны';
        else {
            wh_require_location_access_by_user($u, $location_id);

            $delta_f = (float)$delta;
            if ($delta_f < 0) {
                $bal = wh_get_balance($type, $item_id, $place_id);
                if ($bal < abs($delta_f) - 0.0001) {
                    $msg = 'Нельзя уменьшить ниже нуля. Доступно: ' . $bal;
                    $places = ($location_id>0) ? wh_list_places_for_location($location_id) : [];
                } else {
                    // отрицательная корректировка = движение "из места" в null (как списание)
                    wh_move_create([
                        'item_type'=>$type,'item_id'=>$item_id,'move_type'=>'adjust',
                        'from_place_id'=>$place_id,'to_place_id'=>null,'qty'=>abs($delta_f),
                        'reason'=>$reason,'comment'=>$comment
                    ], (int)$u['id']);

                    header("Location: index.php?m=warehouse&a=details&type=".urlencode($type)."&id=$item_id&location_id=$location_id");
                    exit;
                }
            } else {
                // положительная корректировка = движение "в место" из null
                wh_move_create([
                    'item_type'=>$type,'item_id'=>$item_id,'move_type'=>'adjust',
                    'from_place_id'=>null,'to_place_id'=>$place_id,'qty'=>$delta_f,
                    'reason'=>$reason,'comment'=>$comment
                ], (int)$u['id']);

                header("Location: index.php?m=warehouse&a=details&type=".urlencode($type)."&id=$item_id&location_id=$location_id");
                exit;
            }
        }
        $places = ($location_id>0) ? wh_list_places_for_location($location_id) : [];
    }

    render('warehouse/adjust', [
        'u'=>$u,'type'=>$type,'title'=>$title,'locations'=>$locations,'location_id'=>$location_id,'items'=>$items,'places'=>$places,'msg'=>$msg
    ]);
}

function warehouse_writeoff() {
    $u = require_role(['admin','director','storekeeper','prod_head']);
    wh_ensure_places_exist();

    $type = $_GET['type'] ?? 'tool';
    if (!in_array($type, ['tool','consumable'], true)) $type='tool';

    $locations = wh_get_user_locations_for_warehouse($u);
    $location_id = (int)($_GET['location_id'] ?? 0);
    if ($location_id === 0 && count($locations)===1) $location_id=(int)$locations[0]['location_id'];
    if ($location_id > 0) wh_require_location_access_by_user($u, $location_id);

    if ($type === 'tool') { $tbl='tools'; $title='Списание инструмента'; }
    if ($type === 'consumable') { $tbl='consumables'; $title='Списание расходников'; }

    $items = db_fetch_all(db_query("SELECT id, name FROM $tbl WHERE is_active=1 ORDER BY name"));
    $places = ($location_id>0) ? wh_list_places_for_location($location_id) : [];

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $location_id = (int)($_POST['location_id'] ?? 0);
        $item_id = (int)($_POST['item_id'] ?? 0);
        $from_place = (int)($_POST['from_place_id'] ?? 0);
        $qty = str_replace(',', '.', trim($_POST['qty'] ?? '0'));
        $reason = trim($_POST['reason'] ?? '');
        $comment = trim($_POST['comment'] ?? '');

        if ($location_id<=0 || $item_id<=0 || $from_place<=0) $msg='Заполните локацию, позицию и место списания';
        else if (!is_numeric($qty) || (float)$qty<=0) $msg='Количество должно быть больше 0';
        else if ($reason === '' || $comment === '') $msg='Причина и комментарий обязательны';
        else {
            wh_require_location_access_by_user($u, $location_id);
            $bal = wh_get_balance($type, $item_id, $from_place);
            if ($bal < (float)$qty - 0.0001) {
                $msg = 'Недостаточно остатка. Доступно: ' . $bal;
            } else {
                wh_move_create([
                    'item_type'=>$type,'item_id'=>$item_id,'move_type'=>'writeoff',
                    'from_place_id'=>$from_place,'to_place_id'=>null,'qty'=>(float)$qty,
                    'reason'=>$reason,'comment'=>$comment
                ], (int)$u['id']);

                header("Location: index.php?m=warehouse&a=details&type=".urlencode($type)."&id=$item_id&location_id=$location_id");
                exit;
            }
        }
        $places = ($location_id>0) ? wh_list_places_for_location($location_id) : [];
    }

    render('warehouse/writeoff', [
        'u'=>$u,'type'=>$type,'title'=>$title,'locations'=>$locations,'location_id'=>$location_id,'items'=>$items,'places'=>$places,'msg'=>$msg
    ]);
}

function warehouse_reverse() {
    $u = require_role(['admin','director','storekeeper','prod_head']);
    $id = (int)($_GET['id'] ?? 0);
    $type = $_GET['type'] ?? 'material';
    $item_id = (int)($_GET['item_id'] ?? 0);
    $location_id = (int)($_GET['location_id'] ?? 0);

    if ($id<=0 || $item_id<=0 || $location_id<=0) { header('Location: index.php?m=warehouse&a=index'); exit; }

    // original move
    $m = db_fetch_one(db_query("SELECT * FROM stock_moves WHERE id=$id LIMIT 1"));
    if (!$m || (int)$m['is_reversed']===1) {
        header("Location: index.php?m=warehouse&a=details&type=".urlencode($type)."&id=$item_id&location_id=$location_id");
        exit;
    }

    // создаём обратную запись
    $from = $m['to_place_id'] ? (int)$m['to_place_id'] : null;
    $to = $m['from_place_id'] ? (int)$m['from_place_id'] : null;

    wh_move_create([
        'item_type'=>$m['item_type'],
        'item_id'=>(int)$m['item_id'],
        'move_type'=>'reverse',
        'from_place_id'=>$from,
        'to_place_id'=>$to,
        'qty'=>(float)$m['qty'],
        'reason'=>'Отмена движения #' . (int)$id,
        'comment'=>'Автоотмена',
        'reversed_of'=>$id
    ], (int)$u['id']);

    db_query("UPDATE stock_moves SET is_reversed=1 WHERE id=$id");

    header("Location: index.php?m=warehouse&a=details&type=".urlencode($type)."&id=$item_id&location_id=$location_id");
    exit;
}


function warehouse_products($u, $location_id, $locations) {
    $location_id = (int)$location_id;

    $rows = [];
    if ($location_id>0) {
        $rows = pw_list_balances($location_id);
    }

    render('warehouse/products', [
        'u'=>$u,
        'type'=>'product',
        'locations'=>$locations,
        'location_id'=>$location_id,
        'rows'=>$rows
    ]);
}

function warehouse_product_view() {
    $u = require_role(['admin','director','storekeeper','prod_head','brigadier']);
    $type = 'product';

    $location_id = (int)($_GET['location_id'] ?? 0);
    $product_id = (int)($_GET['id'] ?? 0);

    $locations = wh_get_user_locations_for_warehouse($u);
    if ($location_id === 0 && count($locations)===1) $location_id = (int)$locations[0]['location_id'];
    if ($location_id > 0) wh_require_location_access_by_user($u, $location_id);

    $product = db_fetch_one(db_query("SELECT * FROM products WHERE id=$product_id LIMIT 1"));
    if (!$product) { http_response_code(404); echo "Изделие не найдено"; exit; }

    $bal = ($location_id>0) ? pw_get_balance($location_id, $product_id) : 0;

    $history = [];
    if ($location_id>0) {
        $history = db_fetch_all(db_query("
          SELECT s.*, u.full_name AS user_name,
                 (SELECT qty FROM product_shipment_items i WHERE i.shipment_id=s.id LIMIT 1) AS qty
          FROM product_shipments s
          LEFT JOIN users u ON u.id=s.created_by
          WHERE s.location_id=$location_id
            AND EXISTS (SELECT 1 FROM product_shipment_items i WHERE i.shipment_id=s.id AND i.product_id=$product_id)
          ORDER BY s.shipped_at DESC
          LIMIT 100
        "));
    }

    render('warehouse/product_view', [
        'u'=>$u,
        'type'=>$type,
        'locations'=>$locations,
        'location_id'=>$location_id,
        'product'=>$product,
        'bal'=>$bal,
        'history'=>$history
    ]);
}

function warehouse_product_ship() {
    $u = require_role(['admin','director','storekeeper','prod_head','brigadier']);
    $location_id = (int)($_POST['location_id'] ?? 0);
    $product_id = (int)($_POST['product_id'] ?? 0);
    $qty = str_replace(',', '.', trim($_POST['qty'] ?? '0'));
    $customer = trim($_POST['customer'] ?? '');
    $doc_no = trim($_POST['doc_no'] ?? '');
    $comment = trim($_POST['comment'] ?? '');

    if ($location_id<=0 || $product_id<=0) { header("Location: index.php?m=warehouse&a=index&type=product"); exit; }
    wh_require_location_access_by_user($u, $location_id);

    if (!is_numeric($qty) || (float)$qty<=0) {
        header("Location: index.php?m=warehouse&a=product_view&type=product&id=$product_id&location_id=$location_id&err=qty");
        exit;
    }

    $bal = pw_get_balance($location_id, $product_id);
    if ((float)$qty > $bal) {
        header("Location: index.php?m=warehouse&a=product_view&type=product&id=$product_id&location_id=$location_id&err=bal");
        exit;
    }

    pw_create_shipment($location_id, $product_id, (float)$qty, $customer, $doc_no, $comment, (int)$u['id']);

    header("Location: index.php?m=warehouse&a=product_view&type=product&id=$product_id&location_id=$location_id&ok=1");
    exit;
}

function warehouse_product_cancel() {
    $u = require_role(['admin','director','storekeeper']);
    $shipment_id = (int)($_POST['shipment_id'] ?? 0);
    $location_id = (int)($_POST['location_id'] ?? 0);
    $product_id = (int)($_POST['product_id'] ?? 0);
    $reason = trim($_POST['reason'] ?? '');

    if ($shipment_id<=0 || $location_id<=0 || $product_id<=0) { header("Location: index.php?m=warehouse&a=index&type=product"); exit; }
    wh_require_location_access_by_user($u, $location_id);

    if ($reason==='') $reason='Без причины';
    pw_cancel_shipment($shipment_id, $reason, (int)$u['id']);

    header("Location: index.php?m=warehouse&a=product_view&type=product&id=$product_id&location_id=$location_id&ok=cancel");
    exit;
}
