<?php
if (!function_exists('settings_telegram_prefs')) {
function settings_telegram_prefs() {
    $u = require_role(['admin','director']);
    $tab = 'telegram';

    if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['do'] ?? '')==='save_tg_prefs') {
        $keys = ['low_material','daily_products'];
        $roles = ['admin','director','prod_head','brigadier','storekeeper','otk'];

        foreach ($keys as $k) {
            foreach ($roles as $r) {
                $en = (int)($_POST["en_{$k}_{$r}"] ?? 0);
                $tm = trim($_POST["tm_{$k}_{$r}"] ?? '');
                $tm_sql = ($tm!=='' ? ("'".db_escape($tm)."'") : "NULL");
                db_query("INSERT INTO tg_notify_role(notif_key,role,is_enabled,send_time)
                          VALUES('".db_escape($k)."','".db_escape($r)."',$en,$tm_sql)
                          ON DUPLICATE KEY UPDATE is_enabled=VALUES(is_enabled), send_time=VALUES(send_time)");
            }
        }

        $users = db_fetch_all(db_query("SELECT id FROM users WHERE is_active=1 AND telegram_id<>''"));
        foreach ($keys as $k) {
            foreach ($users as $uu) {
                $uid = (int)$uu['id'];
                $en = isset($_POST["u_en_{$k}_{$uid}"]) ? 1 : 0;
                $tm = trim($_POST["u_tm_{$k}_{$uid}"] ?? '');
                $tm_sql = ($tm!=='' ? ("'".db_escape($tm)."'") : "NULL");
                // сохраняем только если пользователь явно отмечен или задано время
                if ($en===0 && $tm==='') continue;

                db_query("INSERT INTO tg_notify_user(notif_key,user_id,is_enabled,send_time)
                          VALUES('".db_escape($k)."',$uid,$en,$tm_sql)
                          ON DUPLICATE KEY UPDATE is_enabled=VALUES(is_enabled), send_time=VALUES(send_time)");
            }
        }

        if (function_exists('audit')) audit('UPDATE','tg_notify_role',0,(int)$u['id'], ['event'=>'Изменены настройки Telegram-уведомлений'], 'settings');
        header("Location: index.php?m=settings&a=telegram");
        exit;
    }

    $role_rows = db_fetch_all(db_query("SELECT * FROM tg_notify_role ORDER BY notif_key, role"));
    $user_rows = db_fetch_all(db_query("SELECT tnu.*, u.full_name, u.role FROM tg_notify_user tnu JOIN users u ON u.id=tnu.user_id ORDER BY tnu.notif_key, u.full_name"));
    $users = db_fetch_all(db_query("SELECT id, full_name, role, telegram_id FROM users WHERE is_active=1 AND telegram_id<>'' ORDER BY full_name"));

    $role_map = [];
    foreach ($role_rows as $r) $role_map[$r['notif_key']][$r['role']] = $r;
    $user_map = [];
    foreach ($user_rows as $r) $user_map[$r['notif_key']][(int)$r['user_id']] = $r;

    render('settings/telegram_prefs', compact('u','tab','role_map','user_map','users'));
}
}
