<?php
// modules/settings/logs.php
if (!function_exists('settings_logs')) {

function settings_logs() {
    $u = require_role(['admin','director']);

    $today = date('Y-m-d');
    $from = $_GET['from'] ?? date('Y-m-01');
    $to   = $_GET['to'] ?? $today;

    $user_id = (int)($_GET['user_id'] ?? 0);
    $module = trim($_GET['module'] ?? '');
    $action = trim($_GET['action'] ?? '');
    $table  = trim($_GET['table'] ?? '');
    $show_sql = (int)($_GET['show_sql'] ?? 0);

    $from_esc = db_escape($from);
    $to_esc   = db_escape($to);

    $use_new = settings_logs_table_exists('audit_logs');

    if ($use_new) {
        $where = "al.created_at >= '$from_esc 00:00:00' AND al.created_at <= '$to_esc 23:59:59'";
        if ($user_id > 0) $where .= " AND al.user_id=$user_id";
        if ($module !== '') $where .= " AND al.module='" . db_escape($module) . "'";
        if ($action !== '') $where .= " AND al.action='" . db_escape($action) . "'";
        if ($table !== '')  $where .= " AND al.table_name='" . db_escape($table) . "'";

        $users = db_fetch_all(db_query("SELECT id, full_name, role FROM users ORDER BY full_name"));
        $mods  = db_fetch_all(db_query("SELECT DISTINCT module FROM audit_logs ORDER BY module"));
        $acts  = db_fetch_all(db_query("SELECT DISTINCT action FROM audit_logs ORDER BY action"));
        $tabs  = db_fetch_all(db_query("SELECT DISTINCT table_name FROM audit_logs ORDER BY table_name"));

        $rows = db_fetch_all(db_query("
            SELECT al.*, u.full_name AS user_name, u.role AS user_role
            FROM audit_logs al
            LEFT JOIN users u ON u.id=al.user_id
            WHERE $where
            ORDER BY al.id DESC
            LIMIT 800
        "));

    } else {
        // fallback на старую таблицу audit_log, если она есть
        $where = "al.created_at >= '$from_esc 00:00:00' AND al.created_at <= '$to_esc 23:59:59'";
        if ($user_id > 0) $where .= " AND al.user_id=$user_id";
        if ($action !== '') $where .= " AND al.action='" . db_escape($action) . "'";

        $users = db_fetch_all(db_query("SELECT id, full_name, role FROM users ORDER BY full_name"));
        $mods = [];
        $acts = db_fetch_all(db_query("SELECT DISTINCT action FROM audit_log ORDER BY action"));
        $tabs = [];

        $rows = db_fetch_all(db_query("
            SELECT al.*, u.full_name AS user_name, u.role AS user_role
            FROM audit_log al
            LEFT JOIN users u ON u.id=al.user_id
            WHERE $where
            ORDER BY al.id DESC
            LIMIT 800
        "));
        foreach ($rows as &$r) {
            $r['module'] = $r['module'] ?? '';
            $r['table_name'] = $r['table_name'] ?? '';
            $r['row_id'] = $r['row_id'] ?? 0;
            $r['ip'] = $r['ip'] ?? '';
            $r['details'] = $r['details'] ?? '';
        }
        unset($r);
    }

    // Читаемость: формируем event_text и скрываем "sql" по умолчанию
    $out = [];
    foreach ($rows as $r) {
        $det = (string)($r['details'] ?? '');
        $det_arr = null;
        if ($det !== '' && ($det[0] === '{' || $det[0] === '[')) {
            $tmp = json_decode($det, true);
            if (is_array($tmp)) $det_arr = $tmp;
        }

        $is_sql = is_array($det_arr) && isset($det_arr['sql']);
        if ($is_sql && !$show_sql) continue;

        $r['event_text'] = settings_logs_make_event($r, $det_arr);
        // детали красиво: если json — выводим сокращённо
        if (is_array($det_arr)) {
            // убираем огромный sql, если показываем — режем
            if (isset($det_arr['sql'])) {
                $sql = (string)$det_arr['sql'];
                if (mb_strlen($sql) > 300) $sql = mb_substr($sql, 0, 300) . '…';
                $det_arr['sql'] = $sql;
            }
            $r['details'] = json_encode($det_arr, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
        }

        $out[] = $r;
        if (count($out) >= 500) break;
    }

    // хвост файла
    $file_tail = '';
    $log_file = dirname(__DIR__, 2) . '/logs/audit.log';
    if (is_file($log_file)) {
        $file_tail = settings_logs_tail($log_file, 200);
    }

    render('settings/logs', [
        'u'=>$u,
        'tab'=>'logs',
        'from'=>$from,
        'to'=>$to,
        'user_id'=>$user_id,
        'module'=>$module,
        'action'=>$action,
        'table'=>$table,
        'show_sql'=>$show_sql,
        'users'=>$users,
        'mods'=>$mods,
        'acts'=>$acts,
        'tabs'=>$tabs,
        'rows'=>$out,
        'file_tail'=>$file_tail,
    ]);
}

function settings_logs_make_event($r, $det_arr) {
    $action = (string)($r['action'] ?? '');
    $table = (string)($r['table_name'] ?? '');
    $row_id = (int)($r['row_id'] ?? 0);

    // специальные события
    if (is_array($det_arr)) {
        if (!empty($det_arr['event'])) return (string)$det_arr['event'];
        if (!empty($det_arr['photo_deleted'])) return 'Фото сотрудника удалено';
        if (isset($det_arr['sql'])) return 'SQL: ' . $action;
    }

    $base = '';
    if ($action === 'INSERT' || $action === 'CREATE') $base = 'Создано';
    else if ($action === 'UPDATE') $base = 'Изменено';
    else if ($action === 'DELETE') $base = 'Удалено';
    else $base = $action ?: 'Событие';

    $obj = $table ? $table : 'запись';
    $idtxt = $row_id > 0 ? " #$row_id" : '';
    $extra = '';

    if (is_array($det_arr) && isset($det_arr['full_name'])) {
        $extra = ': ' . (string)$det_arr['full_name'];
    } else if (is_array($det_arr) && isset($det_arr['name'])) {
        $extra = ': ' . (string)$det_arr['name'];
    }

    return $base . ' ' . $obj . $idtxt . $extra;
}

function settings_logs_tail($file, $lines=200) {
    $lines = (int)$lines;
    if ($lines < 1) $lines = 1;

    $f = @fopen($file, "rb");
    if (!$f) return '';

    $buffer = '';
    $pos = -1;
    $line_cnt = 0;

    fseek($f, 0, SEEK_END);
    $size = ftell($f);

    while ($size + $pos >= 0 && $line_cnt < $lines) {
        fseek($f, $pos, SEEK_END);
        $ch = fgetc($f);
        if ($ch === "\n") $line_cnt++;
        $buffer = $ch . $buffer;
        $pos--;
    }
    fclose($f);
    return trim($buffer);
}

function settings_logs_table_exists($name) {
    $name = db_escape($name);
    $db = db();
    $sql = "SELECT 1 FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name='$name' LIMIT 1";
    $r = mysqli_query($db, $sql);
    if (!$r) return false;
    $row = mysqli_fetch_row($r);
    return !empty($row);
}

} // function_exists
