<?php
// modules/settings/locations.php — Локации/цеха/маршруты (MVP: маршруты позже)
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';

if (!function_exists('settings_locations')) {
function settings_locations() {
    $u = require_role(['admin','director']);

    $locations = db_fetch_all(db_query("SELECT * FROM locations ORDER BY name"));
    // цеха храним как записи по локациям (может быть одинаковое имя в разных локациях)
    $workshops = db_fetch_all(db_query("
      SELECT w.*, l.name AS location_name
      FROM workshops w
      JOIN locations l ON l.id=w.location_id
      ORDER BY l.name, w.name
    "));

    render('settings/locations', ['u'=>$u,'locations'=>$locations,'workshops'=>$workshops]);
}
}


if (!function_exists('settings_location_edit')) {
function settings_location_edit() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    $item = null;
    if ($id>0) {
        $item = db_fetch_one(db_query("SELECT * FROM locations WHERE id=$id LIMIT 1"));
        if (!$item) { http_response_code(404); echo "Локация не найдена"; exit; }
    }

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $name = trim($_POST['name'] ?? '');
        if ($name==='') $msg='Наименование обязательно';
        else {
            $name_esc = db_escape($name);
            if ($id>0) {
                db_query("UPDATE locations SET name='$name_esc' WHERE id=$id");
                audit('UPDATE','locations',$id,(int)$u['id'], ['name'=>$name]);
            } else {
                db_query("INSERT INTO locations(name) VALUES ('$name_esc')");
                $id = (int)db_last_id();
                audit('CREATE','locations',$id,(int)$u['id'], ['name'=>$name]);
            }
            header('Location: index.php?m=settings&a=locations');
            exit;
        }
        $item = ['id'=>$id,'name'=>$name];
    }

    render('settings/location_edit', ['u'=>$u,'item'=>$item,'msg'=>$msg]);
}
}


if (!function_exists('settings_location_delete')) {
function settings_location_delete() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    if ($id<=0) { header('Location: index.php?m=settings&a=locations'); exit; }

    // запретим удалять, если есть цеха/движения/производство
    $cnt = db_fetch_one(db_query("SELECT COUNT(*) AS c FROM workshops WHERE location_id=$id"));
    if ($cnt && (int)$cnt['c']>0) {
        header('Location: index.php?m=settings&a=locations&err=loc_has_workshops');
        exit;
    }
    db_query("DELETE FROM locations WHERE id=$id");
    audit('DELETE','locations',$id,(int)$u['id'], null);
    header('Location: index.php?m=settings&a=locations');
    exit;
}
}


if (!function_exists('settings_workshop_edit')) {
function settings_workshop_edit() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);

    $locations = db_fetch_all(db_query("SELECT * FROM locations ORDER BY name"));
    $item = null;
    if ($id>0) {
        $item = db_fetch_one(db_query("SELECT * FROM workshops WHERE id=$id LIMIT 1"));
        if (!$item) { http_response_code(404); echo "Цех не найден"; exit; }
    }

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $name = trim($_POST['name'] ?? '');
        $location_id = (int)($_POST['location_id'] ?? 0);
        $apply_all = isset($_POST['apply_all_locations']) ? 1 : 0;

        if ($name==='') $msg='Наименование обязательно';
        else if ($id>0 && $location_id<=0) $msg='Для редактирования существующего цеха нужна локация';
        else {
            $name_esc = db_escape($name);

            if ($id>0) {
                db_query("UPDATE workshops SET name='$name_esc', location_id=$location_id WHERE id=$id");
                audit('UPDATE','workshops',$id,(int)$u['id'], ['name'=>$name,'location_id'=>$location_id]);
            } else {
                if ($apply_all===1 || $location_id===0) {
                    // создаём цех с этим именем во всех локациях (если его там ещё нет)
                    foreach ($locations as $l) {
                        $lid = (int)$l['id'];
                        $exists = db_fetch_one(db_query("SELECT id FROM workshops WHERE location_id=$lid AND name='$name_esc' LIMIT 1"));
                        if ($exists) continue;
                        db_query("INSERT INTO workshops(name, location_id) VALUES ('$name_esc',$lid)");
                        $new_id = (int)db_last_id();
                        audit('CREATE','workshops',$new_id,(int)$u['id'], ['name'=>$name,'location_id'=>$lid,'mode'=>'all_locations']);
                    }
                } else {
                    if ($location_id<=0) { $msg='Выберите локацию или отметьте “во всех локациях”'; }
                    else {
                        db_query("INSERT INTO workshops(name, location_id) VALUES ('$name_esc',$location_id)");
                        $id = (int)db_last_id();
                        audit('CREATE','workshops',$id,(int)$u['id'], ['name'=>$name,'location_id'=>$location_id]);
                    }
                }
            }

            if ($msg==='') {
                header('Location: index.php?m=settings&a=locations');
                exit;
            }
        }

        $item = ['id'=>$id,'name'=>$name,'location_id'=>$location_id];
    }

    render('settings/workshop_edit', ['u'=>$u,'item'=>$item,'locations'=>$locations,'msg'=>$msg]);
}
}


if (!function_exists('settings_workshop_delete')) {
function settings_workshop_delete() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    if ($id<=0) { header('Location: index.php?m=settings&a=locations'); exit; }

    // запретим, если есть производство/работники/места хранения
    $c1 = db_fetch_one(db_query("SELECT COUNT(*) AS c FROM employees WHERE workshop_id=$id"));
    $c2 = db_fetch_one(db_query("SELECT COUNT(*) AS c FROM operations WHERE workshop_id=$id"));
    if (($c1 && (int)$c1['c']>0) || ($c2 && (int)$c2['c']>0)) {
        header('Location: index.php?m=settings&a=locations&err=ws_has_data');
        exit;
    }

    db_query("DELETE FROM workshops WHERE id=$id");
    audit('DELETE','workshops',$id,(int)$u['id'], null);
    header('Location: index.php?m=settings&a=locations');
    exit;
}
}

